/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.core.AbstractAsynchronousResponse;
import org.jboss.resteasy.core.AbstractExecutionContext;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.providers.FormUrlEncodedProvider;
import org.jboss.resteasy.plugins.server.netty.NettyHttpResponse;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.NotImplementedYetException;
import org.jboss.resteasy.spi.ResteasyAsynchronousContext;
import org.jboss.resteasy.spi.ResteasyAsynchronousResponse;
import org.jboss.resteasy.spi.ResteasyUriInfo;
import org.jboss.resteasy.spi.UnhandledException;
import org.jboss.resteasy.util.Encode;

public class NettyHttpRequest
implements HttpRequest {
    protected ResteasyHttpHeaders httpHeaders;
    protected SynchronousDispatcher dispatcher;
    protected ResteasyUriInfo uriInfo;
    protected String httpMethod;
    protected MultivaluedMap<String, String> formParameters;
    protected MultivaluedMap<String, String> decodedFormParameters;
    protected InputStream inputStream;
    protected Map<String, Object> attributes = new HashMap<String, Object>();
    protected NettyHttpResponse response;
    private final boolean is100ContinueExpected;
    private NettyExecutionContext executionContext;
    private final ChannelHandlerContext ctx;
    private volatile boolean flushed;

    public NettyHttpRequest(ChannelHandlerContext ctx, ResteasyHttpHeaders httpHeaders, ResteasyUriInfo uri, String httpMethod, SynchronousDispatcher dispatcher, NettyHttpResponse response, boolean is100ContinueExpected) {
        this.is100ContinueExpected = is100ContinueExpected;
        this.response = response;
        this.dispatcher = dispatcher;
        this.httpHeaders = httpHeaders;
        this.httpMethod = httpMethod;
        this.uriInfo = uri;
        this.executionContext = new NettyExecutionContext(this, response, dispatcher);
        this.ctx = ctx;
    }

    public MultivaluedMap<String, String> getMutableHeaders() {
        return this.httpHeaders.getMutableHeaders();
    }

    public void setHttpMethod(String method) {
        this.httpMethod = method;
    }

    public Enumeration<String> getAttributeNames() {
        Enumeration<String> en = new Enumeration<String>(){
            private Iterator<String> it;
            {
                this.it = NettyHttpRequest.this.attributes.keySet().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            @Override
            public String nextElement() {
                return this.it.next();
            }
        };
        return en;
    }

    public ResteasyAsynchronousContext getAsyncContext() {
        return this.executionContext;
    }

    public boolean isFlushed() {
        return this.flushed;
    }

    public MultivaluedMap<String, String> getFormParameters() {
        if (this.formParameters != null) {
            return this.formParameters;
        }
        if (this.getHttpHeaders().getMediaType().isCompatible(MediaType.valueOf((String)"application/x-www-form-urlencoded"))) {
            try {
                this.formParameters = FormUrlEncodedProvider.parseForm((InputStream)this.getInputStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException("Request media type is not application/x-www-form-urlencoded");
        }
        return this.formParameters;
    }

    public MultivaluedMap<String, String> getDecodedFormParameters() {
        if (this.decodedFormParameters != null) {
            return this.decodedFormParameters;
        }
        this.decodedFormParameters = Encode.decode(this.getFormParameters());
        return this.decodedFormParameters;
    }

    public Object getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream stream) {
        this.inputStream = stream;
    }

    public ResteasyUriInfo getUri() {
        return this.uriInfo;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setRequestUri(URI requestUri) throws IllegalStateException {
        this.uriInfo = this.uriInfo.setRequestUri(requestUri);
    }

    public void setRequestUri(URI baseUri, URI requestUri) throws IllegalStateException {
        this.uriInfo = new ResteasyUriInfo(baseUri.resolve(requestUri));
    }

    public boolean isInitial() {
        return true;
    }

    public NettyHttpResponse getResponse() {
        return this.response;
    }

    public boolean isKeepAlive() {
        return this.response.isKeepAlive();
    }

    public boolean is100ContinueExpected() {
        return this.is100ContinueExpected;
    }

    public void forward(String path) {
        throw new NotImplementedYetException();
    }

    public boolean wasForwarded() {
        return false;
    }

    class NettyExecutionContext
    extends AbstractExecutionContext {
        protected final NettyHttpRequest request;
        protected final NettyHttpResponse response;
        protected volatile boolean done;
        protected volatile boolean cancelled;
        protected volatile boolean wasSuspended;
        protected NettyHttpAsyncResponse asyncResponse;

        public NettyExecutionContext(NettyHttpRequest request, NettyHttpResponse response, SynchronousDispatcher dispatcher) {
            super(dispatcher, (HttpRequest)request, (HttpResponse)response);
            this.request = request;
            this.response = response;
            this.asyncResponse = new NettyHttpAsyncResponse(dispatcher, request, response);
        }

        public boolean isSuspended() {
            return this.wasSuspended;
        }

        public ResteasyAsynchronousResponse getAsyncResponse() {
            return this.asyncResponse;
        }

        public ResteasyAsynchronousResponse suspend() throws IllegalStateException {
            return this.suspend(-1L);
        }

        public ResteasyAsynchronousResponse suspend(long millis) throws IllegalStateException {
            return this.suspend(millis, TimeUnit.MILLISECONDS);
        }

        public ResteasyAsynchronousResponse suspend(long time, TimeUnit unit) throws IllegalStateException {
            if (this.wasSuspended) {
                throw new IllegalStateException("Already suspended");
            }
            this.wasSuspended = true;
            return this.asyncResponse;
        }

        class NettyHttpAsyncResponse
        extends AbstractAsynchronousResponse {
            private final Object responseLock;
            protected ScheduledFuture timeoutFuture;
            private NettyHttpResponse nettyResponse;

            public NettyHttpAsyncResponse(SynchronousDispatcher dispatcher, NettyHttpRequest request, NettyHttpResponse response) {
                super(dispatcher, (HttpRequest)request, (HttpResponse)response);
                this.responseLock = new Object();
                this.nettyResponse = response;
            }

            public void initialRequestThreadFinished() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean resume(Object entity) {
                Object object = this.responseLock;
                synchronized (object) {
                    boolean bl;
                    if (NettyExecutionContext.this.done) {
                        return false;
                    }
                    if (NettyExecutionContext.this.cancelled) {
                        return false;
                    }
                    try {
                        bl = this.internalResume(entity);
                        NettyExecutionContext.this.done = true;
                    }
                    catch (Throwable throwable) {
                        NettyExecutionContext.this.done = true;
                        NettyHttpRequest.this.ctx.writeAndFlush((Object)this.nettyResponse.getDefaultFullHttpResponse());
                        throw throwable;
                    }
                    NettyHttpRequest.this.ctx.writeAndFlush((Object)this.nettyResponse.getDefaultFullHttpResponse());
                    return bl;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean resume(Throwable ex) {
                Object object = this.responseLock;
                synchronized (object) {
                    boolean bl;
                    if (NettyExecutionContext.this.done) {
                        return false;
                    }
                    if (NettyExecutionContext.this.cancelled) {
                        return false;
                    }
                    try {
                        bl = this.internalResume(ex);
                        NettyExecutionContext.this.done = true;
                        this.nettyFlush();
                    }
                    catch (UnhandledException unhandled) {
                        boolean bl2;
                        try {
                            bl2 = this.internalResume(Response.status((int)500).build());
                            NettyExecutionContext.this.done = true;
                            this.nettyFlush();
                        }
                        catch (Throwable throwable) {
                            NettyExecutionContext.this.done = true;
                            this.nettyFlush();
                            throw throwable;
                        }
                        return bl2;
                    }
                    return bl;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel() {
                Object object = this.responseLock;
                synchronized (object) {
                    boolean bl;
                    if (NettyExecutionContext.this.cancelled) {
                        return true;
                    }
                    if (NettyExecutionContext.this.done) {
                        return false;
                    }
                    NettyExecutionContext.this.done = true;
                    NettyExecutionContext.this.cancelled = true;
                    try {
                        bl = this.internalResume(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build());
                        this.nettyFlush();
                    }
                    catch (Throwable throwable) {
                        this.nettyFlush();
                        throw throwable;
                    }
                    return bl;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel(int retryAfter) {
                Object object = this.responseLock;
                synchronized (object) {
                    boolean bl;
                    if (NettyExecutionContext.this.cancelled) {
                        return true;
                    }
                    if (NettyExecutionContext.this.done) {
                        return false;
                    }
                    NettyExecutionContext.this.done = true;
                    NettyExecutionContext.this.cancelled = true;
                    try {
                        bl = this.internalResume(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).header("Retry-After", (Object)retryAfter).build());
                        this.nettyFlush();
                    }
                    catch (Throwable throwable) {
                        this.nettyFlush();
                        throw throwable;
                    }
                    return bl;
                }
            }

            protected synchronized void nettyFlush() {
                NettyHttpRequest.this.flushed = true;
                NettyHttpRequest.this.ctx.writeAndFlush((Object)this.nettyResponse.getDefaultFullHttpResponse());
                NettyHttpRequest.this.ctx.close();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel(Date retryAfter) {
                Object object = this.responseLock;
                synchronized (object) {
                    boolean bl;
                    if (NettyExecutionContext.this.cancelled) {
                        return true;
                    }
                    if (NettyExecutionContext.this.done) {
                        return false;
                    }
                    NettyExecutionContext.this.done = true;
                    NettyExecutionContext.this.cancelled = true;
                    try {
                        bl = this.internalResume(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).header("Retry-After", (Object)retryAfter).build());
                        this.nettyFlush();
                    }
                    catch (Throwable throwable) {
                        this.nettyFlush();
                        throw throwable;
                    }
                    return bl;
                }
            }

            public boolean isSuspended() {
                return !NettyExecutionContext.this.done && !NettyExecutionContext.this.cancelled;
            }

            public boolean isCancelled() {
                return NettyExecutionContext.this.cancelled;
            }

            public boolean isDone() {
                return NettyExecutionContext.this.done;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean setTimeout(long time, TimeUnit unit) {
                Object object = this.responseLock;
                synchronized (object) {
                    if (NettyExecutionContext.this.done || NettyExecutionContext.this.cancelled) {
                        return false;
                    }
                    if (this.timeoutFuture != null && !this.timeoutFuture.cancel(false)) {
                        return false;
                    }
                    Runnable task = new Runnable(){

                        @Override
                        public void run() {
                            NettyHttpAsyncResponse.this.handleTimeout();
                        }
                    };
                    this.timeoutFuture = NettyHttpRequest.this.ctx.executor().schedule(task, time, unit);
                }
                return true;
            }

            protected void handleTimeout() {
                if (this.timeoutHandler != null) {
                    this.timeoutHandler.handleTimeout((AsyncResponse)this);
                }
                if (NettyExecutionContext.this.done) {
                    return;
                }
                this.resume((Throwable)new ServiceUnavailableException());
            }
        }
    }
}

