/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ext.RuntimeDelegate;
import org.jboss.resteasy.plugins.server.netty.NettyHttpResponse;
import org.jboss.resteasy.plugins.server.netty.RequestDispatcher;

@ChannelHandler.Sharable
public class RestEasyHttpResponseEncoder
extends MessageToMessageEncoder<NettyHttpResponse> {
    private final RequestDispatcher dispatcher;

    public RestEasyHttpResponseEncoder(RequestDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    protected void encode(ChannelHandlerContext ctx, NettyHttpResponse nettyResponse, List<Object> out) throws Exception {
        ByteBuf buffer = nettyResponse.getBuffer();
        if (buffer.readableBytes() == 0) {
            return;
        }
        DefaultFullHttpResponse response = nettyResponse.getDefaultFullHttpResponse();
        for (Map.Entry entry : nettyResponse.getOutputHeaders().entrySet()) {
            String key = (String)entry.getKey();
            for (Object value : (List)entry.getValue()) {
                RuntimeDelegate.HeaderDelegate delegate = this.dispatcher.providerFactory.getHeaderDelegate(value.getClass());
                if (delegate != null) {
                    response.headers().add(key, (Object)delegate.toString(value));
                    continue;
                }
                response.headers().set(key, (Object)value.toString());
            }
        }
        if (nettyResponse.isKeepAlive()) {
            response.headers().set("Content-Length", (Object)buffer.readableBytes());
            response.headers().set("Connection", (Object)"keep-alive");
        }
        out.add(response);
    }
}

