/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import java.io.InputStream;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.oneone.OneToOneDecoder;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.server.netty.NettyHttpRequest;
import org.jboss.resteasy.plugins.server.netty.NettyHttpResponse;
import org.jboss.resteasy.plugins.server.netty.NettyUtil;
import org.jboss.resteasy.plugins.server.netty.i18n.LogMessages;
import org.jboss.resteasy.plugins.server.netty.i18n.Messages;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;

@ChannelHandler.Sharable
public class RestEasyHttpRequestDecoder
extends OneToOneDecoder {
    private final SynchronousDispatcher dispatcher;
    private final String servletMappingPrefix;
    private final String proto;
    private final boolean isKeepAlive;

    public RestEasyHttpRequestDecoder(SynchronousDispatcher dispatcher, String servletMappingPrefix, Protocol protocol, boolean isKeepAlive) {
        this.dispatcher = dispatcher;
        this.servletMappingPrefix = servletMappingPrefix;
        this.proto = protocol == Protocol.HTTP ? "http" : "https";
        this.isKeepAlive = isKeepAlive;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (!(msg instanceof HttpRequest)) {
            return msg;
        }
        HttpRequest request = (HttpRequest)msg;
        boolean keepAlive = HttpHeaders.isKeepAlive((HttpMessage)request) & this.isKeepAlive;
        NettyHttpResponse response = new NettyHttpResponse(channel, keepAlive, request.getMethod());
        ResteasyHttpHeaders headers = null;
        ResteasyUriInfo uriInfo = null;
        try {
            headers = NettyUtil.extractHttpHeaders(request);
            uriInfo = NettyUtil.extractUriInfo(request, this.servletMappingPrefix, this.proto);
            NettyHttpRequest nettyRequest = new NettyHttpRequest(headers, uriInfo, request.getMethod().getName(), this.dispatcher, response, HttpHeaders.is100ContinueExpected((HttpMessage)request));
            ChannelBufferInputStream is = new ChannelBufferInputStream(request.getContent());
            nettyRequest.setInputStream((InputStream)is);
            return nettyRequest;
        }
        catch (Exception e) {
            response.sendError(400);
            LogMessages.LOGGER.warn(Messages.MESSAGES.failedToParseRequest(), e);
            return null;
        }
    }

    public static enum Protocol {
        HTTPS,
        HTTP;

    }
}

