/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.plugins.server.netty.NettyHttpRequest;
import org.jboss.resteasy.plugins.server.netty.NettyHttpResponse;
import org.jboss.resteasy.plugins.server.netty.NettyJaxrsServer;
import org.jboss.resteasy.plugins.server.netty.RequestDispatcher;
import org.jboss.resteasy.spi.Failure;

@ChannelHandler.Sharable
public class RequestHandler
extends SimpleChannelUpstreamHandler {
    protected final RequestDispatcher dispatcher;
    private static final Logger logger = Logger.getLogger(RequestHandler.class);

    public RequestHandler(RequestDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (e.getMessage() instanceof NettyHttpRequest) {
            NettyHttpRequest request = (NettyHttpRequest)e.getMessage();
            if (request.is100ContinueExpected()) {
                this.send100Continue(e);
            }
            NettyHttpResponse response = request.getResponse();
            try {
                this.dispatcher.service(request, response, true);
            }
            catch (Failure e1) {
                response.reset();
                response.setStatus(e1.getErrorCode());
                return;
            }
            catch (Exception ex) {
                response.reset();
                response.setStatus(500);
                logger.error("Unexpected", (Throwable)ex);
                return;
            }
            ChannelFuture future = e.getChannel().write((Object)response);
            NettyJaxrsServer.allChannels.add((Object)e.getChannel());
            if (!request.isKeepAlive()) {
                future.addListener(ChannelFutureListener.CLOSE);
            }
        }
    }

    private void send100Continue(MessageEvent e) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
        e.getChannel().write((Object)response);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (e.getCause() instanceof TooLongFrameException) {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
            e.getChannel().write((Object)response).addListener(ChannelFutureListener.CLOSE);
        } else {
            e.getCause().printStackTrace();
            e.getChannel().close();
        }
    }
}

