/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLContext;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.server.embedded.EmbeddedJaxrsServer;
import org.jboss.resteasy.plugins.server.embedded.SecurityDomain;
import org.jboss.resteasy.plugins.server.netty.HttpServerPipelineFactory;
import org.jboss.resteasy.plugins.server.netty.HttpsServerPipelineFactory;
import org.jboss.resteasy.plugins.server.netty.RequestDispatcher;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class NettyJaxrsServer
implements EmbeddedJaxrsServer {
    protected ServerBootstrap bootstrap;
    protected Channel channel;
    protected int port = 8080;
    protected ResteasyDeployment deployment = new ResteasyDeployment();
    protected String root = "";
    protected SecurityDomain domain;
    private int ioWorkerCount = Runtime.getRuntime().availableProcessors() * 2;
    private int executorThreadCount = 16;
    private SSLContext sslContext;
    private int maxRequestSize = 0xA00000;
    static final ChannelGroup allChannels = new DefaultChannelGroup("NettyJaxrsServer");

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setIoWorkerCount(int ioWorkerCount) {
        this.ioWorkerCount = ioWorkerCount;
    }

    public void setExecutorThreadCount(int executorThreadCount) {
        this.executorThreadCount = executorThreadCount;
    }

    public void setMaxRequestSize(int maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setDeployment(ResteasyDeployment deployment) {
        this.deployment = deployment;
    }

    public void setRootResourcePath(String rootResourcePath) {
        this.root = rootResourcePath;
        if (this.root != null && this.root.equals("/")) {
            this.root = "";
        }
    }

    public ResteasyDeployment getDeployment() {
        return this.deployment;
    }

    public void setSecurityDomain(SecurityDomain sc) {
        this.domain = sc;
    }

    public void start() {
        this.deployment.start();
        RequestDispatcher dispatcher = new RequestDispatcher((SynchronousDispatcher)this.deployment.getDispatcher(), this.deployment.getProviderFactory(), this.domain);
        this.bootstrap = new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool(), this.ioWorkerCount));
        HttpServerPipelineFactory factory = this.sslContext == null ? new HttpServerPipelineFactory(dispatcher, this.root, this.executorThreadCount, this.maxRequestSize) : new HttpsServerPipelineFactory(dispatcher, this.root, this.executorThreadCount, this.maxRequestSize, this.sslContext);
        this.bootstrap.setPipelineFactory((ChannelPipelineFactory)factory);
        this.channel = this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.port));
        allChannels.add((Object)this.channel);
    }

    public void stop() {
        allChannels.close().awaitUninterruptibly();
        if (this.bootstrap != null) {
            this.bootstrap.releaseExternalResources();
        }
        this.deployment.stop();
    }
}

