/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.links.impl;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.links.LinkResource;
import org.jboss.resteasy.links.LinksProvider;
import org.jboss.resteasy.links.RESTServiceDiscovery;
import org.jboss.resteasy.links.impl.EJBConstraintChecker;
import org.jboss.resteasy.links.impl.ServiceMethodsRegistry;
import org.jboss.resteasy.spi.ResteasyUriBuilder;

public final class ClassLinksProvider
implements LinksProvider<Class<?>> {
    private final UriInfo uriInfo;
    private final ServiceMethodsRegistry registry;
    private final EJBConstraintChecker constraintChecker;

    public ClassLinksProvider(UriInfo uriInfo, ResourceMethodRegistry resourceMethodRegistry) {
        this.uriInfo = uriInfo;
        this.registry = new ServiceMethodsRegistry(resourceMethodRegistry);
        this.constraintChecker = new EJBConstraintChecker();
    }

    @Override
    public RESTServiceDiscovery getLinks(Class<?> entityClass) {
        RESTServiceDiscovery links = new RESTServiceDiscovery();
        for (Method method : this.registry.getMethods()) {
            for (LinkResource linkResource : this.registry.getLinkResources(method)) {
                Class<?> type = this.registry.getServiceType(linkResource, method);
                if (!entityClass.isAssignableFrom(type) || !this.constraintChecker.check(method)) continue;
                this.processLinkResource(method, links);
            }
        }
        return links;
    }

    @Override
    public RESTServiceDiscovery getLinks(Class<?> entityClass, ClassLoader classLoader) {
        RESTServiceDiscovery links = new RESTServiceDiscovery();
        for (Method method : this.registry.getMethods()) {
            for (LinkResource linkResource : this.registry.getLinkResources(method)) {
                Class<?> type = this.registry.getServiceType(linkResource, method, classLoader);
                if (!entityClass.isAssignableFrom(type) || !this.constraintChecker.check(method, classLoader)) continue;
                this.processLinkResource(method, links);
            }
        }
        return links;
    }

    private void processLinkResource(Method method, RESTServiceDiscovery links) {
        List paramNames;
        UriBuilder uriBuilder = this.uriInfo.getBaseUriBuilder().path(method.getDeclaringClass());
        if (method.isAnnotationPresent(Path.class)) {
            uriBuilder.path(method);
        }
        if (!(paramNames = ((ResteasyUriBuilder)uriBuilder).getPathParamNamesInDeclarationOrder()).isEmpty()) {
            return;
        }
        URI uri = uriBuilder.build(new Object[0]);
        if (method.isAnnotationPresent(GET.class)) {
            links.addLink(uri, "list");
        } else if (method.isAnnotationPresent(POST.class)) {
            links.addLink(uri, "add");
        }
    }
}

