/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.links.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.Id;
import javax.xml.bind.annotation.XmlID;
import org.jboss.resteasy.links.ParentResource;
import org.jboss.resteasy.links.ResourceID;
import org.jboss.resteasy.links.ResourceIDs;
import org.jboss.resteasy.links.i18n.Messages;
import org.jboss.resteasy.links.impl.NotFoundException;

public class BeanUtils {
    private static final Class<Annotation>[] IdAnnotationList = new Class[]{ResourceID.class, XmlID.class, Id.class};

    public static List<Object> findIDs(Object entity) {
        Class<?> klass = entity.getClass();
        ResourceIDs resourceIDs = BeanUtils.findTypeAnnotation(klass, ResourceIDs.class);
        if (resourceIDs != null) {
            String[] names = resourceIDs.value();
            ArrayList<Object> values = new ArrayList<Object>();
            for (String name : names) {
                try {
                    values.add(BeanUtils.getPropertyValue(entity, entity.getClass(), name));
                }
                catch (NotFoundException e) {
                    throw new RuntimeException(Messages.MESSAGES.failedToFindBeanProperty(name));
                }
            }
            return values;
        }
        for (Class<Annotation> idAnnotationClass : IdAnnotationList) {
            try {
                return Collections.singletonList(BeanUtils.findAnnotatedProperty(entity, klass, idAnnotationClass));
            }
            catch (NotFoundException notFoundException) {
            }
        }
        return Collections.emptyList();
    }

    private static Object getPropertyValue(Object entity, Class<?> klass, String name) throws NotFoundException {
        try {
            return BeanUtils.readPropertyMethods(entity, klass, name, false);
        }
        catch (NotFoundException notFoundException) {
            while (true) {
                try {
                    return BeanUtils.readPropertyMethods(entity, klass, name, true);
                }
                catch (NotFoundException notFoundException2) {
                    try {
                        Field f = klass.getDeclaredField(name);
                        return BeanUtils.readField(f, entity);
                    }
                    catch (SecurityException e) {
                        throw new RuntimeException(Messages.MESSAGES.failedToReadProperty(name), e);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        if ((klass = klass.getSuperclass()) != null) continue;
                        throw new NotFoundException();
                    }
                }
                break;
            }
        }
    }

    private static Object readPropertyMethods(Object entity, Class<?> klass, String propertyName, boolean b) throws NotFoundException {
        try {
            return BeanUtils.readPropertyMethod(entity, klass, "is" + BeanUtils.capitalise(propertyName), false);
        }
        catch (NotFoundException notFoundException) {
            return BeanUtils.readPropertyMethod(entity, klass, "get" + BeanUtils.capitalise(propertyName), false);
        }
    }

    private static Object readPropertyMethod(Object entity, Class<?> klass, String methodName, boolean declared) throws NotFoundException {
        try {
            Method getter = declared ? klass.getDeclaredMethod(methodName, new Class[0]) : klass.getMethod(methodName, new Class[0]);
            return BeanUtils.readMethod(getter, entity);
        }
        catch (SecurityException e) {
            throw new RuntimeException(Messages.MESSAGES.failedToReadProperty(methodName), e);
        }
        catch (NoSuchMethodException e) {
            throw new NotFoundException();
        }
    }

    private static String capitalise(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private static <T extends Annotation> T findTypeAnnotation(Class<?> klass, Class<T> annotationClass) {
        do {
            if (!klass.isAnnotationPresent(annotationClass)) continue;
            return klass.getAnnotation(annotationClass);
        } while ((klass = klass.getSuperclass()) != null);
        return null;
    }

    public static Object findParentResource(Object entity) {
        try {
            return BeanUtils.findAnnotatedProperty(entity, entity.getClass(), ParentResource.class);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    private static Object findAnnotatedProperty(Object entity, Class<?> type, Class<? extends Annotation> annotation) throws NotFoundException {
        for (Field field : type.getDeclaredFields()) {
            if (!field.isAnnotationPresent(annotation)) continue;
            return BeanUtils.readField(field, entity);
        }
        for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
            if (!accessibleObject.isAnnotationPresent(annotation) || !BeanUtils.isBeanAccessor((Method)accessibleObject)) continue;
            return BeanUtils.readMethod((Method)accessibleObject, entity);
        }
        if (type.getSuperclass() != null) {
            return BeanUtils.findAnnotatedProperty(entity, type.getSuperclass(), annotation);
        }
        throw new NotFoundException();
    }

    private static Object readMethod(Method m, Object entity) {
        m.setAccessible(true);
        try {
            Object object = m.invoke(entity, new Object[0]);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.MESSAGES.failedToReadPropertyFromMethod(m.getName()), e);
        }
        finally {
            m.setAccessible(false);
        }
    }

    private static Object readField(Field f, Object entity) {
        f.setAccessible(true);
        try {
            Object object = f.get(entity);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.MESSAGES.failedToReadField(f.getName()), e);
        }
        finally {
            f.setAccessible(false);
        }
    }

    private static boolean isBeanAccessor(Method m) {
        String name = m.getName();
        return (name.startsWith("get") || name.startsWith("is")) && m.getParameterTypes().length == 0;
    }
}

