/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.links.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.Form;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.links.LinkResource;
import org.jboss.resteasy.links.LinkResources;
import org.jboss.resteasy.links.RESTServiceDiscovery;
import org.jboss.resteasy.links.i18n.Messages;
import org.jboss.resteasy.links.impl.ServiceDiscoveryException;
import org.jboss.resteasy.spi.ResourceInvoker;
import org.jboss.resteasy.spi.util.FindAnnotation;

public abstract class AbstractLinksProvider<T> {
    protected final UriInfo uriInfo;
    protected final List<Method> serviceMethods;

    public AbstractLinksProvider(UriInfo uriInfo, ResourceMethodRegistry resourceMethodRegistry) {
        this.uriInfo = uriInfo;
        this.serviceMethods = this.getServiceMethods(resourceMethodRegistry);
    }

    public abstract RESTServiceDiscovery getLinks(T var1);

    protected List<LinkResource> getLinkResources(Method method) {
        LinkedList<LinkResource> linkResources = new LinkedList<LinkResource>();
        if (method.getAnnotation(LinkResource.class) != null) {
            linkResources.add(method.getAnnotation(LinkResource.class));
        }
        if (method.getAnnotation(LinkResources.class) != null) {
            linkResources.addAll(Arrays.asList(method.getAnnotation(LinkResources.class).value()));
        }
        return linkResources;
    }

    protected boolean checkEJBConstraint(Method m) {
        try {
            Class.forName("javax.annotation.security.RolesAllowed");
        }
        catch (ClassNotFoundException e) {
            return true;
        }
        RolesAllowed rolesAllowed = m.getAnnotation(RolesAllowed.class);
        if (rolesAllowed == null) {
            return true;
        }
        SecurityContext context = (SecurityContext)ResteasyContext.getContextData(SecurityContext.class);
        for (String role : rolesAllowed.value()) {
            if (!context.isUserInRole(role)) continue;
            return true;
        }
        return false;
    }

    protected Class<?> getServiceType(LinkResource service, Method m) {
        Class<?> type;
        if (service.value() != Void.class) {
            return service.value();
        }
        if (!service.entityClassName().isEmpty()) {
            try {
                return Class.forName(service.entityClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (Void.TYPE == (type = this.findBodyType(m))) {
            throw new ServiceDiscoveryException(m, Messages.MESSAGES.cannotGuessResourceType());
        }
        if (Collection.class.isAssignableFrom(type)) {
            throw new ServiceDiscoveryException(m, Messages.MESSAGES.cannotGuessCollectionType());
        }
        if (Response.class.isAssignableFrom(type)) {
            throw new ServiceDiscoveryException(m, Messages.MESSAGES.cannotGuessType());
        }
        return type;
    }

    private Class<?> findBodyType(Method m) {
        Annotation[][] annotations = m.getParameterAnnotations();
        Class<?>[] types = m.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            if (FindAnnotation.findJaxRSAnnotations((Annotation[])annotations[i]).length != 0 || FindAnnotation.findAnnotation((Annotation[])annotations[i], Form.class) != null) continue;
            return types[i];
        }
        return m.getReturnType();
    }

    private List<Method> getServiceMethods(ResourceMethodRegistry registry) {
        ArrayList<Method> results = new ArrayList<Method>();
        for (Map.Entry entry : registry.getBounded().entrySet()) {
            List invokers = (List)entry.getValue();
            for (ResourceInvoker invoker : invokers) {
                if (!(invoker instanceof ResourceMethodInvoker)) continue;
                ResourceMethodInvoker resourceMethod = (ResourceMethodInvoker)invoker;
                Method method = resourceMethod.getMethod();
                results.add(method);
            }
        }
        return results;
    }
}

