/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.links;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.links.LinkResource;
import org.jboss.resteasy.links.RESTServiceDiscovery;
import org.jboss.resteasy.links.impl.AbstractLinksProvider;
import org.jboss.resteasy.spi.ResteasyUriBuilder;

public class ClassLinksProvider
extends AbstractLinksProvider<Class<?>> {
    public ClassLinksProvider(UriInfo uriInfo, ResourceMethodRegistry resourceMethodRegistry) {
        super(uriInfo, resourceMethodRegistry);
    }

    @Override
    public RESTServiceDiscovery getLinks(Class<?> entityClass) {
        RESTServiceDiscovery restServiceDiscovery = new RESTServiceDiscovery();
        for (Method method : this.serviceMethods) {
            for (LinkResource linkResource : this.getLinkResources(method)) {
                this.processLinkResource(entityClass, method, restServiceDiscovery, linkResource);
            }
        }
        return restServiceDiscovery;
    }

    private void processLinkResource(Class<?> entityClass, Method method, RESTServiceDiscovery links, LinkResource linkResource) {
        List paramNames;
        if (!entityClass.isAssignableFrom(this.getServiceType(linkResource, method)) || !this.checkEJBConstraint(method)) {
            return;
        }
        UriBuilder uriBuilder = this.uriInfo.getBaseUriBuilder().path(method.getDeclaringClass());
        if (method.isAnnotationPresent(Path.class)) {
            uriBuilder.path(method);
        }
        if (!(paramNames = ((ResteasyUriBuilder)uriBuilder).getPathParamNamesInDeclarationOrder()).isEmpty()) {
            return;
        }
        URI uri = uriBuilder.build(new Object[0]);
        if (method.isAnnotationPresent(GET.class)) {
            links.addLink(uri, "list");
        } else if (method.isAnnotationPresent(POST.class)) {
            links.addLink(uri, "add");
        }
    }
}

