/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.links.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.el.ELContext;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.Form;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.links.ELProvider;
import org.jboss.resteasy.links.LinkELProvider;
import org.jboss.resteasy.links.LinkResource;
import org.jboss.resteasy.links.LinkResources;
import org.jboss.resteasy.links.ParamBinding;
import org.jboss.resteasy.links.RESTServiceDiscovery;
import org.jboss.resteasy.links.ResourceFacade;
import org.jboss.resteasy.links.i18n.LogMessages;
import org.jboss.resteasy.links.i18n.Messages;
import org.jboss.resteasy.links.impl.BeanUtils;
import org.jboss.resteasy.links.impl.EL;
import org.jboss.resteasy.links.impl.ServiceDiscoveryException;
import org.jboss.resteasy.spi.ResourceInvoker;
import org.jboss.resteasy.spi.ResteasyUriBuilder;
import org.jboss.resteasy.spi.util.FindAnnotation;

public class RESTUtils {
    public static <T> T addDiscovery(T entity, UriInfo uriInfo, ResourceMethodRegistry registry) {
        Field injectionField = RESTUtils.findInjectionField(entity);
        if (injectionField == null) {
            return entity;
        }
        List<Method> methods = RESTUtils.getServiceMethods(registry);
        RESTServiceDiscovery ret = null;
        try {
            injectionField.setAccessible(true);
            ret = (RESTServiceDiscovery)injectionField.get(entity);
        }
        catch (Exception e) {
            LogMessages.LOGGER.error(Messages.MESSAGES.failedToReuseServiceDiscovery(entity), e);
        }
        if (ret == null) {
            ret = new RESTServiceDiscovery();
        }
        for (Method m : methods) {
            RESTUtils.processLinkResources(m, entity, uriInfo, ret);
        }
        if (ret.isEmpty()) {
            return entity;
        }
        try {
            injectionField.set(entity, ret);
            injectionField.setAccessible(false);
        }
        catch (Exception e) {
            LogMessages.LOGGER.error(Messages.MESSAGES.failedToInjectLinks(entity), e);
        }
        return entity;
    }

    private static Field findInjectionField(Object entity) {
        Class<?> klass = entity.getClass();
        do {
            for (Field f : klass.getDeclaredFields()) {
                if (!f.getType().equals(RESTServiceDiscovery.class)) continue;
                return f;
            }
        } while ((klass = klass.getSuperclass()) != null);
        return null;
    }

    public static List<Method> getServiceMethods(ResourceMethodRegistry registry) {
        ArrayList<Method> results = new ArrayList<Method>();
        for (Map.Entry entry : registry.getBounded().entrySet()) {
            List invokers = (List)entry.getValue();
            for (ResourceInvoker invoker : invokers) {
                if (!(invoker instanceof ResourceMethodInvoker)) continue;
                ResourceMethodInvoker resourceMethod = (ResourceMethodInvoker)invoker;
                Method method = resourceMethod.getMethod();
                results.add(method);
            }
        }
        return results;
    }

    private static void processLinkResources(Method m, Object entity, UriInfo uriInfo, RESTServiceDiscovery ret) {
        LinkResources services;
        LinkResource service = m.getAnnotation(LinkResource.class);
        if (service != null) {
            RESTUtils.processLinkResource(m, entity, uriInfo, ret, service);
        }
        if ((services = m.getAnnotation(LinkResources.class)) != null) {
            for (LinkResource service2 : services.value()) {
                RESTUtils.processLinkResource(m, entity, uriInfo, ret, service2);
            }
        }
    }

    private static void processLinkResource(Method m, Object entity, UriInfo uriInfo, RESTServiceDiscovery ret, LinkResource service) {
        String rel = service.rel();
        Class<?> type = RESTUtils.getServiceType(service, m);
        if (type.isInstance(entity)) {
            if (RESTUtils.checkConstraint(service, entity, m)) {
                RESTUtils.addInstanceService(m, entity, uriInfo, ret, service, rel);
            }
        } else if (entity instanceof ResourceFacade && ((ResourceFacade)entity).facadeFor() == type && RESTUtils.checkConstraint(service, type, m)) {
            RESTUtils.addService(m, (ResourceFacade)entity, uriInfo, ret, service, rel);
        }
    }

    private static Class<?> getServiceType(LinkResource service, Method m) {
        Class<?> type = service.value();
        if (type != Void.class) {
            return type;
        }
        type = RESTUtils.findBodyType(m);
        if (type == null) {
            type = m.getReturnType();
        }
        if (Void.TYPE == type) {
            throw new ServiceDiscoveryException(m, Messages.MESSAGES.cannotGuessResourceType());
        }
        if (Collection.class.isAssignableFrom(type)) {
            throw new ServiceDiscoveryException(m, Messages.MESSAGES.cannotGuessCollectionType());
        }
        if (Response.class.isAssignableFrom(type)) {
            throw new ServiceDiscoveryException(m, Messages.MESSAGES.cannotGuessType());
        }
        return type;
    }

    private static Class<?> findBodyType(Method m) {
        Annotation[][] annotations = m.getParameterAnnotations();
        Class<?>[] types = m.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            if (FindAnnotation.findJaxRSAnnotations((Annotation[])annotations[i]).length != 0 || FindAnnotation.findAnnotation((Annotation[])annotations[i], Form.class) != null) continue;
            return types[i];
        }
        return null;
    }

    private static boolean checkConstraint(LinkResource service, Object object, Method m) {
        String constraint = service.constraint();
        if (constraint == null || constraint.length() == 0) {
            return RESTUtils.checkEJBConstraint(m);
        }
        Boolean ret = RESTUtils.evaluateELBoolean(m, RESTUtils.getELContext(m, object), object, constraint);
        return ret != null && ret != false;
    }

    private static boolean checkEJBConstraint(Method m) {
        try {
            Class.forName("javax.annotation.security.RolesAllowed");
        }
        catch (ClassNotFoundException e) {
            return true;
        }
        RolesAllowed rolesAllowed = m.getAnnotation(RolesAllowed.class);
        if (rolesAllowed == null) {
            return true;
        }
        SecurityContext context = (SecurityContext)ResteasyContext.getContextData(SecurityContext.class);
        for (String role : rolesAllowed.value()) {
            if (!context.isUserInRole(role)) continue;
            return true;
        }
        return false;
    }

    private static void addService(Method m, ResourceFacade<?> entity, UriInfo uriInfo, RESTServiceDiscovery ret, LinkResource service, String rel) {
        URI uri;
        List paramNames;
        Map<String, Object> pathParameters = entity.pathParameters();
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder().path(m.getDeclaringClass());
        if (m.isAnnotationPresent(Path.class)) {
            uriBuilder.path(m);
        }
        if ((paramNames = ((ResteasyUriBuilder)uriBuilder).getPathParamNamesInDeclarationOrder()).isEmpty()) {
            uri = uriBuilder.build(new Object[0]);
        } else if (pathParameters.size() >= paramNames.size()) {
            uri = uriBuilder.buildFromMap(pathParameters);
        } else {
            return;
        }
        if (rel.length() == 0) {
            if (m.isAnnotationPresent(GET.class)) {
                rel = "list";
            } else if (m.isAnnotationPresent(POST.class)) {
                rel = "add";
            }
        }
        ret.addLink(uri, rel);
    }

    private static void addInstanceService(Method m, Object entity, UriInfo uriInfo, RESTServiceDiscovery ret, LinkResource service, String rel) {
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder().path(m.getDeclaringClass());
        if (m.isAnnotationPresent(Path.class)) {
            uriBuilder.path(m);
        }
        URI uri = RESTUtils.buildURI(uriBuilder, service, entity, m);
        if (rel.length() == 0) {
            if (m.isAnnotationPresent(GET.class)) {
                Class<?> type = m.getReturnType();
                rel = Collection.class.isAssignableFrom(type) ? "list" : "self";
            } else if (m.isAnnotationPresent(PUT.class)) {
                rel = "update";
            } else if (m.isAnnotationPresent(POST.class)) {
                rel = "add";
            } else if (m.isAnnotationPresent(DELETE.class)) {
                rel = "remove";
            }
        }
        ret.addLink(uri, rel);
    }

    private static URI buildURI(UriBuilder uriBuilder, LinkResource service, Object entity, Method m) {
        for (ParamBinding binding : service.queryParameters()) {
            uriBuilder.queryParam(binding.name(), new Object[]{RESTUtils.evaluateEL(m, RESTUtils.getELContext(m, entity), entity, binding.value())});
        }
        for (ParamBinding binding : service.matrixParameters()) {
            uriBuilder.matrixParam(binding.name(), new Object[]{RESTUtils.evaluateEL(m, RESTUtils.getELContext(m, entity), entity, binding.value())});
        }
        String[] uriTemplates = service.pathParameters();
        if (uriTemplates.length > 0) {
            Object[] values = new Object[uriTemplates.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = RESTUtils.evaluateEL(m, RESTUtils.getELContext(m, entity), entity, uriTemplates[i]);
            }
            return uriBuilder.build(values);
        }
        List paramNames = ((ResteasyUriBuilder)uriBuilder).getPathParamNamesInDeclarationOrder();
        if (paramNames.isEmpty()) {
            return uriBuilder.build(new Object[0]);
        }
        List<Object> params = RESTUtils.findURIParamsFromResource(entity);
        if (params.size() == paramNames.size()) {
            return uriBuilder.build(params.toArray());
        }
        if (params.size() > paramNames.size()) {
            return uriBuilder.build(params.subList(0, paramNames.size()).toArray());
        }
        throw new ServiceDiscoveryException(m, Messages.MESSAGES.notEnoughtUriParameters(paramNames.size(), params.size()));
    }

    private static List<Object> findURIParamsFromResource(Object entity) {
        ArrayList<Object> ids = new ArrayList<Object>();
        do {
            List<Object> theseIDs = BeanUtils.findIDs(entity);
            ids.addAll(0, theseIDs);
        } while ((entity = BeanUtils.findParentResource(entity)) != null);
        return ids;
    }

    private static LinkELProvider findLinkELProvider(Method m) {
        if (m.isAnnotationPresent(LinkELProvider.class)) {
            return m.getAnnotation(LinkELProvider.class);
        }
        Class<?> c = m.getDeclaringClass();
        if (c.isAnnotationPresent(LinkELProvider.class)) {
            return c.getAnnotation(LinkELProvider.class);
        }
        Package p = c.getPackage();
        if (p != null && p.isAnnotationPresent(LinkELProvider.class)) {
            return p.getAnnotation(LinkELProvider.class);
        }
        return null;
    }

    private static ELProvider getELProvider(Method m) {
        LinkELProvider linkElProvider = RESTUtils.findLinkELProvider(m);
        if (linkElProvider == null) {
            return null;
        }
        Class<? extends ELProvider> elProviderClass = linkElProvider.value();
        try {
            return elProviderClass.newInstance();
        }
        catch (Exception x) {
            LogMessages.LOGGER.error(Messages.MESSAGES.couldNotInstantiateELProviderClass(elProviderClass.getName()), x);
            throw new ServiceDiscoveryException(m, Messages.MESSAGES.failedToInstantiateELProvider(elProviderClass.getName()), x);
        }
    }

    private static ELContext getELContext(Method m, Object base) {
        ELContext ours = EL.createELContext(base);
        ELProvider elProvider = RESTUtils.getELProvider(m);
        if (elProvider != null) {
            return elProvider.getContext(ours);
        }
        return ours;
    }

    public static Map<String, ? extends Object> derivePathParameters(UriInfo uriInfo) {
        MultivaluedMap pathParameters = uriInfo.getPathParameters();
        HashMap ret = new HashMap();
        for (Map.Entry entry : pathParameters.entrySet()) {
            ret.put(entry.getKey(), ((List)entry.getValue()).get(0));
        }
        return ret;
    }

    public static Object evaluateEL(Method m, ELContext context, Object base, String expression) {
        try {
            return EL.EXPRESSION_FACTORY.createValueExpression(context, expression, Object.class).getValue(context);
        }
        catch (Exception x) {
            throw new ServiceDiscoveryException(m, Messages.MESSAGES.failedToEvaluateELExpression(expression), x);
        }
    }

    public static Boolean evaluateELBoolean(Method m, ELContext context, Object base, String expression) {
        try {
            return (Boolean)EL.EXPRESSION_FACTORY.createValueExpression(context, expression, Boolean.class).getValue(context);
        }
        catch (Exception x) {
            throw new ServiceDiscoveryException(m, Messages.MESSAGES.failedToEvaluateELExpression(expression), x);
        }
    }
}

