/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.keystone.as7;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.acl.Group;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MediaType;
import org.apache.catalina.connector.Request;
import org.jboss.resteasy.keystone.as7.JBossWebAuthLoginModule;
import org.jboss.resteasy.keystone.as7.i18n.LogMessages;
import org.jboss.resteasy.keystone.as7.i18n.Messages;
import org.jboss.resteasy.keystone.core.UserPrincipal;
import org.jboss.resteasy.keystone.model.Access;
import org.jboss.resteasy.keystone.model.Role;
import org.jboss.resteasy.security.smime.PKCS7SignatureInput;
import org.jboss.security.JSSESecurityDomain;
import org.jboss.security.SecurityDomain;
import org.jboss.security.SecurityUtil;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;

public class SignedSkeletonKeyStoneLoginModule
extends JBossWebAuthLoginModule {
    private static final String SECURITY_DOMAIN = "securityDomain";
    protected String projectId;
    protected String skeletonKeyCertificateAlias;
    protected Access access;
    private Object domain = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.projectId = (String)options.get("projectId");
        this.skeletonKeyCertificateAlias = (String)options.get("skeleton.key.certificate.alias");
        String sd = (String)options.get(SECURITY_DOMAIN);
        LogMessages.LOGGER.error(Messages.MESSAGES.securityDomain(sd));
        sd = SecurityUtil.unprefixSecurityDomain((String)sd);
        if (sd == null) {
            sd = "other";
        }
        try {
            Object tempDomain = new InitialContext().lookup("java:jboss/jaas/" + sd);
            if (tempDomain instanceof SecurityDomain) {
                this.domain = tempDomain;
            } else {
                tempDomain = new InitialContext().lookup("java:jboss/jaas/" + sd + "/jsse");
                if (tempDomain instanceof JSSESecurityDomain) {
                    this.domain = tempDomain;
                } else {
                    LogMessages.LOGGER.error(Messages.MESSAGES.securityDomainNotValid(sd));
                }
            }
        }
        catch (NamingException e) {
            LogMessages.LOGGER.error(Messages.MESSAGES.unableToFindSecurityDomain(sd), e);
        }
    }

    @Override
    protected boolean login(Request request, HttpServletResponse response) throws LoginException {
        String tokenHeader = request.getHeader("X-Auth-Signed-Token");
        if (tokenHeader == null) {
            return false;
        }
        KeyStore keyStore = null;
        if (this.domain != null) {
            if (this.domain instanceof SecurityDomain) {
                keyStore = ((SecurityDomain)this.domain).getKeyStore();
            } else if (this.domain instanceof JSSESecurityDomain) {
                keyStore = ((JSSESecurityDomain)this.domain).getKeyStore();
            }
        }
        if (keyStore == null) {
            throw new LoginException(Messages.MESSAGES.noTrustStoreFound());
        }
        X509Certificate certificate = null;
        try {
            certificate = (X509Certificate)keyStore.getCertificate(this.skeletonKeyCertificateAlias);
        }
        catch (KeyStoreException e) {
            throw new LoginException(Messages.MESSAGES.couldNotGetCertificate());
        }
        try {
            PKCS7SignatureInput input = new PKCS7SignatureInput(tokenHeader);
            if (!input.verify(certificate)) {
                throw new LoginException(Messages.MESSAGES.badSignature());
            }
            this.access = (Access)input.getEntity(Access.class, MediaType.APPLICATION_JSON_TYPE);
        }
        catch (LoginException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LoginException(Messages.MESSAGES.badToken());
        }
        if (this.access.getToken().expired()) {
            throw new LoginException(Messages.MESSAGES.tokenExpired());
        }
        if (!this.projectId.equals(this.access.getToken().getProject().getId())) {
            throw new LoginException(Messages.MESSAGES.tokenProjectIdDoesntMatch());
        }
        this.loginOk = true;
        return true;
    }

    protected Principal getIdentity() {
        UserPrincipal principal = new UserPrincipal(this.access.getUser());
        return principal;
    }

    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup roles = new SimpleGroup("Roles");
        Group[] roleSets = new Group[]{roles};
        for (Role role : this.access.getUser().getRoles()) {
            roles.addMember((Principal)new SimplePrincipal(role.getName()));
        }
        return roleSets;
    }
}

