/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jsapi;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.resteasy.jsapi.MethodMetaData;
import org.jboss.resteasy.jsapi.MethodParamMetaData;
import org.jboss.resteasy.jsapi.ServiceRegistry;
import org.jboss.resteasy.jsapi.i18n.LogMessages;
import org.jboss.resteasy.jsapi.i18n.Messages;
import org.jboss.resteasy.util.PathHelper;

public class JSAPIWriter {
    private static final long serialVersionUID = -1985015444704126795L;

    public void writeJavaScript(String base, HttpServletRequest req, HttpServletResponse resp, Map<String, ServiceRegistry> serviceRegistries) throws IOException {
        LogMessages.LOGGER.debug(Messages.MESSAGES.startResteasyClient());
        String ifNoneMatch = req.getHeader("If-None-Match");
        String etag = this.generateEtag(serviceRegistries);
        resp.setHeader("Etag", etag);
        if (ifNoneMatch != null && ifNoneMatch.equals(etag)) {
            resp.setStatus(304);
            return;
        }
        for (Map.Entry<String, ServiceRegistry> entry : serviceRegistries.entrySet()) {
            String uri = base;
            if (entry.getKey() != null) {
                uri = this.resolveDoubleSlash(uri, entry.getKey(), true);
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(new BufferedWriter(stringWriter));
            this.writeJavaScript(uri, writer, entry.getValue());
            writer.flush();
            writer.close();
            if (this.clientIsGzipSupported(req)) {
                ByteArrayOutputStream compressedContent = new ByteArrayOutputStream();
                GZIPOutputStream gzipstream = new GZIPOutputStream(compressedContent);
                gzipstream.write(stringWriter.toString().getBytes());
                gzipstream.finish();
                byte[] compressedBytes = compressedContent.toByteArray();
                resp.setContentLength(compressedBytes.length);
                resp.addHeader("Content-Encoding", "gzip");
                ServletOutputStream output = resp.getOutputStream();
                output.write(compressedBytes);
                output.flush();
                output.close();
                continue;
            }
            ServletOutputStream output = resp.getOutputStream();
            byte[] bytes = stringWriter.toString().getBytes();
            resp.setContentLength(bytes.length);
            output.write(bytes);
            output.flush();
            output.close();
        }
    }

    private boolean clientIsGzipSupported(HttpServletRequest req) {
        String encoding = req.getHeader("Accept-Encoding");
        return encoding != null && encoding.contains("gzip");
    }

    public void writeJavaScript(String uri, PrintWriter writer, ServiceRegistry serviceRegistry) throws IOException {
        this.copyResource("/resteasy-client.js", writer);
        LogMessages.LOGGER.debug(Messages.MESSAGES.startJaxRsApi());
        LogMessages.LOGGER.debug(Messages.MESSAGES.restApiUrl(uri));
        writer.println("REST.apiURL = '" + uri + "';");
        HashSet<String> declaredPrefixes = new HashSet<String>();
        this.printService(writer, serviceRegistry, declaredPrefixes, uri);
    }

    private String generateEtag(Map<String, ServiceRegistry> serviceRegistries) {
        StringBuilder etagBuilder = new StringBuilder();
        for (Map.Entry<String, ServiceRegistry> entry : serviceRegistries.entrySet()) {
            if (entry.getKey() != null) {
                etagBuilder.append(entry.getKey()).append(':');
            }
            this.generateEtag(entry.getValue(), etagBuilder);
        }
        return String.valueOf(Math.abs(etagBuilder.toString().hashCode()));
    }

    private void generateEtag(ServiceRegistry serviceRegistry, StringBuilder etagBuilder) {
        for (MethodMetaData methodMetaData : serviceRegistry.getMethodMetaData()) {
            etagBuilder.append(methodMetaData.hashCode());
            for (ServiceRegistry subService : serviceRegistry.getLocators()) {
                this.generateEtag(subService, etagBuilder);
            }
        }
    }

    private void printService(PrintWriter writer, ServiceRegistry serviceRegistry, Set<String> declaredPrefixes, String uri) {
        for (MethodMetaData methodMetaData : serviceRegistry.getMethodMetaData()) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.path(methodMetaData.getUri()));
            LogMessages.LOGGER.debug(Messages.MESSAGES.invoker(methodMetaData.getInvoker()));
            String declaringPrefix = methodMetaData.getFunctionPrefix();
            this.declarePrefix(writer, declaringPrefix, declaredPrefixes);
            for (String httpMethod : methodMetaData.getHttpMethods()) {
                this.print(writer, httpMethod, methodMetaData, uri);
            }
        }
        for (ServiceRegistry subService : serviceRegistry.getLocators()) {
            this.printService(writer, subService, declaredPrefixes, uri);
        }
    }

    private void declarePrefix(PrintWriter writer, String declaringPrefix, Set<String> declaredPrefixes) {
        if (declaredPrefixes.add(declaringPrefix)) {
            int lastDot = declaringPrefix.lastIndexOf(".");
            if (lastDot == -1) {
                writer.println("var " + declaringPrefix + " = {};");
            } else {
                this.declarePrefix(writer, declaringPrefix.substring(0, lastDot), declaredPrefixes);
                writer.println(declaringPrefix + " = {};");
            }
        }
    }

    private void copyResource(String name, PrintWriter writer) throws IOException {
        int read;
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(name));
        char[] array = new char[1024];
        while ((read = reader.read(array)) >= 0) {
            writer.write(array, 0, read);
        }
        ((Reader)reader).close();
    }

    private void print(PrintWriter writer, String httpMethod, MethodMetaData methodMetaData, String uri) {
        String methodUri = methodMetaData.getUri();
        writer.println("// " + httpMethod + " " + methodUri);
        writer.println(methodMetaData.getFunctionName() + " = function(_params){");
        writer.println(" var params = _params ? _params : {};");
        writer.println(" var request = new REST.Request();");
        writer.println(" request.setMethod('" + httpMethod + "');");
        writer.println(" var uri = params.$apiURL ? params.$apiURL : REST.apiURL;");
        if (methodUri.contains("{")) {
            this.printURIParams(methodUri, writer);
        } else {
            String resolvedMethodUri = this.resolveDoubleSlash(uri, methodUri, false);
            writer.println(" uri += '" + resolvedMethodUri + "';");
        }
        this.printOtherParams(methodMetaData, writer);
        writer.println(" request.setURI(uri);");
        writer.println(" if(params.$username && params.$password)");
        writer.println("  request.setCredentials(params.$username, params.$password);");
        writer.println(" if(params.$accepts)");
        writer.println("  request.setAccepts(params.$accepts);");
        if (methodMetaData.getWants() != null) {
            writer.println(" else");
            writer.println("  request.setAccepts('" + methodMetaData.getWants() + "');");
        }
        writer.println("if (REST.antiBrowserCache == true) {");
        writer.println("  request.addQueryParameter('resteasy_jsapi_anti_cache', (new Date().getTime()));");
        writer.println("    var cached_obj = REST._get_cache_signature(REST._generate_cache_signature(uri));");
        writer.println("    if (cached_obj != null) { request.addHeader('If-Modified-Since', cached_obj[1]['Last-Modified']); request.addHeader('If-None-Match', cached_obj[1]['Etag']);}");
        writer.println("}");
        writer.println(" if(params.$contentType)");
        writer.println("  request.setContentType(params.$contentType);");
        writer.println(" else");
        writer.println("  request.setContentType('" + methodMetaData.getConsumesMIMEType() + "');");
        writer.println(" if(params.$callback){");
        writer.println("  request.execute(params.$callback);");
        writer.println(" }else{");
        writer.println("  var returnValue;");
        writer.println("  request.setAsync(false);");
        writer.println("  var callback = function(httpCode, xmlHttpRequest, value){ returnValue = value;};");
        writer.println("  request.execute(callback);");
        writer.println("  return returnValue;");
        writer.println(" }");
        writer.println("};");
    }

    private void printOtherParams(MethodMetaData methodMetaData, PrintWriter writer) {
        List<MethodParamMetaData> params = methodMetaData.getParameters();
        for (MethodParamMetaData methodParamMetaData : params) {
            this.printParameter(methodParamMetaData, writer);
        }
    }

    private void printParameter(MethodParamMetaData metaData, PrintWriter writer) {
        switch (metaData.getParamType()) {
            case QUERY_PARAMETER: {
                this.print(metaData, writer, "QueryParameter");
                break;
            }
            case HEADER_PARAMETER: {
                this.print(metaData, writer, "Header");
                break;
            }
            case COOKIE_PARAMETER: {
                this.print(metaData, writer, "Cookie");
                break;
            }
            case MATRIX_PARAMETER: {
                this.print(metaData, writer, "MatrixParameter");
                break;
            }
            case FORM_PARAMETER: {
                this.print(metaData, writer, "FormParameter");
                break;
            }
            case FORM: {
                this.print(metaData, writer, "Form");
                break;
            }
            case ENTITY_PARAMETER: {
                writer.println(" if(params.$entity)");
                writer.println("  request.setEntity(params.$entity);");
            }
        }
    }

    private void print(MethodParamMetaData metaData, PrintWriter writer, String type) {
        String paramName = metaData.getParamName();
        writer.println(String.format(" if(Object.prototype.hasOwnProperty.call(params, '%s'))\n  request.add%s('%s', params.%s);", paramName, type, paramName, paramName));
    }

    private void printURIParams(String uri, PrintWriter writer) {
        String replacedCurlyURI = PathHelper.replaceEnclosedCurlyBraces((String)uri);
        Matcher matcher = PathHelper.URI_PARAM_PATTERN.matcher(replacedCurlyURI);
        int i = 0;
        while (matcher.find()) {
            if (matcher.start() > i) {
                writer.println(" uri += '" + replacedCurlyURI.substring(i, matcher.start()) + "';");
            }
            String name = matcher.group(1);
            writer.println(" uri += REST.Encoding.encodePathSegment(params." + name + ");");
            i = matcher.end();
        }
        if (i < replacedCurlyURI.length()) {
            writer.println(" uri += '" + replacedCurlyURI.substring(i) + "';");
        }
    }

    private String resolveDoubleSlash(String uri, String uriToAppend, boolean appendToUri) {
        if (uri.endsWith("/") && uriToAppend.startsWith("/")) {
            if (uriToAppend.length() > 1) {
                if (appendToUri) {
                    return uri.concat(uriToAppend.substring(1));
                }
                return uriToAppend.substring(1);
            }
            if (appendToUri) {
                return uri;
            }
            return "";
        }
        if (appendToUri) {
            return uri.concat(uriToAppend);
        }
        return uriToAppend;
    }
}

