/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jsapi;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Path;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ResourceLocator;
import org.jboss.resteasy.core.ResourceMethod;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.jsapi.MethodMetaData;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.GetRestful;

public class ServiceRegistry {
    private static final Logger logger = Logger.getLogger(ServiceRegistry.class);
    private static final long serialVersionUID = -1985015444704126795L;
    private ResourceMethodRegistry registry;
    private ResteasyProviderFactory providerFactory;
    private ServiceRegistry parent;
    private ArrayList<MethodMetaData> methods;
    private ArrayList<ServiceRegistry> locators;
    private ResourceLocator locator;
    private String uri;
    private String functionPrefix;

    public ServiceRegistry(ServiceRegistry parent, ResourceMethodRegistry registry, ResteasyProviderFactory providerFactory, ResourceLocator locator) {
        this.parent = parent;
        this.registry = registry;
        this.providerFactory = providerFactory;
        this.locator = locator;
        if (locator != null) {
            Method method = locator.getMethod();
            Path methodPath = method.getAnnotation(Path.class);
            Class<?> declaringClass = method.getDeclaringClass();
            Path classPath = declaringClass.getAnnotation(Path.class);
            this.uri = MethodMetaData.appendURIFragments(parent, classPath, methodPath);
            this.functionPrefix = parent.isRoot() ? declaringClass.getSimpleName() + "." + method.getName() : parent.getFunctionPrefix() + "." + method.getName();
        }
        this.scanRegistry();
    }

    private void scanRegistry() {
        this.methods = new ArrayList();
        this.locators = new ArrayList();
        for (Map.Entry entry : this.registry.getRoot().getBounded().entrySet()) {
            List invokers = (List)entry.getValue();
            for (ResourceInvoker invoker : invokers) {
                Class[] locatorResourceTypes;
                if (invoker instanceof ResourceMethod) {
                    this.methods.add(new MethodMetaData(this, (ResourceMethod)invoker));
                    continue;
                }
                if (!(invoker instanceof ResourceLocator)) continue;
                ResourceLocator locator = (ResourceLocator)invoker;
                Method method = locator.getMethod();
                Class<?> locatorType = method.getReturnType();
                for (Class locatorResourceType : locatorResourceTypes = GetRestful.getSubResourceClasses(locatorType)) {
                    if (locatorResourceType == null) {
                        if (!logger.isWarnEnabled()) continue;
                        logger.warn("Impossible to generate JSAPI for subresource returned by method " + method.getDeclaringClass().getName() + "." + method.getName() + " since return type is not a static JAXRS resource type");
                        continue;
                    }
                    ResourceMethodRegistry locatorRegistry = new ResourceMethodRegistry(this.providerFactory);
                    locatorRegistry.addResourceFactory(null, null, locatorResourceType);
                    this.locators.add(new ServiceRegistry(this, locatorRegistry, this.providerFactory, locator));
                }
            }
        }
    }

    public List<MethodMetaData> getMethodMetaData() {
        return this.methods;
    }

    public List<ServiceRegistry> getLocators() {
        return this.locators;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public String getFunctionPrefix() {
        return this.functionPrefix;
    }

    public void collectResourceMethodsUntilRoot(List<Method> methods) {
        if (this.isRoot()) {
            return;
        }
        methods.add(this.locator.getMethod());
        this.parent.collectResourceMethodsUntilRoot(methods);
    }
}

