/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.jboss.resteasy.core.LoggerCategories;
import org.jboss.resteasy.plugins.providers.ByteArrayProvider;
import org.jboss.resteasy.plugins.providers.DataSourceProvider;
import org.jboss.resteasy.plugins.providers.DefaultTextPlain;
import org.jboss.resteasy.plugins.providers.FormUrlEncodedProvider;
import org.jboss.resteasy.plugins.providers.InputStreamProvider;
import org.jboss.resteasy.plugins.providers.StreamingOutputProvider;
import org.jboss.resteasy.plugins.providers.StringTextStar;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBElementProvider;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBXmlRootElementProvider;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBXmlTypeProvider;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.slf4j.Logger;

public class RegisterBuiltin {
    private static final Logger logger = LoggerCategories.getProviderLogger();

    public static void register(ResteasyProviderFactory factory) {
        logger.debug("Registering standard providers");
        DataSourceProvider dataSourceProvider = new DataSourceProvider();
        factory.addMessageBodyReader(dataSourceProvider);
        factory.addMessageBodyWriter(dataSourceProvider);
        logger.info("Added {}", (Object)dataSourceProvider.getClass().getSimpleName());
        DefaultTextPlain plainText = new DefaultTextPlain();
        factory.addMessageBodyReader(plainText);
        factory.addMessageBodyWriter(plainText);
        logger.info("Added {}", (Object)plainText.getClass().getSimpleName());
        JAXBXmlRootElementProvider jaxb = new JAXBXmlRootElementProvider();
        factory.addMessageBodyReader(jaxb);
        factory.addMessageBodyWriter(jaxb);
        logger.info("Added {}", (Object)jaxb.getClass().getSimpleName());
        JAXBElementProvider elementProvider = new JAXBElementProvider();
        factory.addMessageBodyReader(elementProvider);
        factory.addMessageBodyWriter(elementProvider);
        logger.info("Added {}", (Object)elementProvider.getClass().getSimpleName());
        JAXBXmlTypeProvider xmlType = new JAXBXmlTypeProvider();
        factory.addMessageBodyReader(xmlType);
        factory.addMessageBodyWriter(xmlType);
        logger.info("Added {}", (Object)xmlType.getClass().getSimpleName());
        StringTextStar stringTextStar = new StringTextStar();
        factory.addMessageBodyReader(stringTextStar);
        factory.addMessageBodyWriter(stringTextStar);
        InputStreamProvider inputStreamProvider = new InputStreamProvider();
        factory.addMessageBodyReader(inputStreamProvider);
        factory.addMessageBodyWriter(inputStreamProvider);
        ByteArrayProvider byteArrayProvider = new ByteArrayProvider();
        factory.addMessageBodyReader(byteArrayProvider);
        factory.addMessageBodyWriter(byteArrayProvider);
        FormUrlEncodedProvider formProvider = new FormUrlEncodedProvider();
        factory.addMessageBodyReader(formProvider);
        factory.addMessageBodyWriter(formProvider);
        factory.addMessageBodyWriter(new StreamingOutputProvider());
        RegisterBuiltin.optionalProvider("javax.imageio.IIOImage", "org.jboss.resteasy.plugins.providers.IIOImageProvider", factory);
        RegisterBuiltin.optionalProvider("org.codehaus.jettison.json.JSONObject", "org.jboss.resteasy.plugins.providers.jaxb.json.JsonJAXBElementProvider", factory);
        RegisterBuiltin.optionalProvider("org.codehaus.jettison.json.JSONObject", "org.jboss.resteasy.plugins.providers.jaxb.json.JsonXmlTypeProvider", factory);
        RegisterBuiltin.optionalProvider("org.codehaus.jettison.json.JSONObject", "org.jboss.resteasy.plugins.providers.jaxb.json.JsonXmlRootElementProvider", factory);
        RegisterBuiltin.optionalProvider("javax.mail.internet.MimeMultipart", "org.jboss.resteasy.plugins.providers.MimeMultipartProvider", factory);
        RegisterBuiltin.optionalProvider("org.ho.yaml.Yaml", "org.jboss.resteasy.plugins.providers.YamlProvider", factory);
        RegisterBuiltin.optionalProvider("com.sun.xml.fastinfoset.stax.StAXDocumentSerializer", "org.jboss.resteasy.plugins.providers.jaxb.fastinfoset.FastinfoSetXmlRootElementProvider", factory);
        RegisterBuiltin.optionalProvider("com.sun.xml.fastinfoset.stax.StAXDocumentSerializer", "org.jboss.resteasy.plugins.providers.jaxb.fastinfoset.FastinfoSetJAXBElementProvider", factory);
        RegisterBuiltin.optionalProvider("com.sun.xml.fastinfoset.stax.StAXDocumentSerializer", "org.jboss.resteasy.plugins.providers.jaxb.fastinfoset.FastinfoSetXmlTypeProvider", factory);
    }

    private static void optionalProvider(String dependency, String providerClass, ResteasyProviderFactory factory) {
        if (RegisterBuiltin.isAvailable(dependency)) {
            logger.info("Adding " + providerClass);
            Object provider = RegisterBuiltin.instantiate(providerClass);
            factory.addMessageBodyReader((MessageBodyReader)provider);
            factory.addMessageBodyWriter((MessageBodyWriter)provider);
        }
    }

    private static boolean isAvailable(String className) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(className);
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    private static Object instantiate(String className) {
        try {
            Class<?> cl = Thread.currentThread().getContextClassLoader().loadClass(className);
            return cl.newInstance();
        }
        catch (Exception e) {
            logger.error("Failed to load: " + className, (Throwable)e);
            return null;
        }
    }
}

