/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyReader;
import org.jboss.resteasy.core.ValueInjector;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.LoggableFailure;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class MessageBodyParameterInjector
implements ValueInjector {
    private Class type;
    private Type genericType;
    private Annotation[] annotations;
    private ResteasyProviderFactory factory;

    public MessageBodyParameterInjector(Class type, Type genericType, Annotation[] annotations, ResteasyProviderFactory factory) {
        this.type = type;
        this.factory = factory;
        this.genericType = genericType;
        this.annotations = annotations;
    }

    public Object inject(HttpRequest request, HttpResponse response) {
        try {
            MediaType mediaType = request.getHttpHeaders().getMediaType();
            if (mediaType == null) {
                throw new LoggableFailure("content-type was null and expecting to extract a body", 400);
            }
            MessageBodyReader reader = this.factory.getMessageBodyReader(this.type, this.genericType, this.annotations, mediaType);
            if (reader == null) {
                throw new LoggableFailure("Could not find message body reader for type: " + this.genericType + " of content type: " + mediaType, 400);
            }
            return reader.readFrom(this.type, this.genericType, this.annotations, mediaType, request.getHttpHeaders().getRequestHeaders(), request.getInputStream());
        }
        catch (IOException e) {
            throw new LoggableFailure("Failure extracting body", (Throwable)e, 500);
        }
    }

    public Object inject() {
        throw new RuntimeException("Illegal to inject a message body into a singleton");
    }
}

