/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.httpclient.HttpClient;
import org.jboss.resteasy.client.core.ClientInvoker;
import org.jboss.resteasy.client.core.ClientProxy;
import org.jboss.resteasy.client.core.DeleteInvoker;
import org.jboss.resteasy.client.core.GetInvoker;
import org.jboss.resteasy.client.core.PostInvoker;
import org.jboss.resteasy.client.core.PutInvoker;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.IsHttpMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyFactory {
    public static <T> T create(Class<T> clazz, String base) {
        return ProxyFactory.create(clazz, base, new HttpClient());
    }

    public static <T> T create(Class<T> clazz, String base, HttpClient client) {
        try {
            return ProxyFactory.create(clazz, new URI(base), client, ResteasyProviderFactory.getInstance());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T create(Class<T> clazz, URI baseUri, HttpClient httpClient, ResteasyProviderFactory providerFactory) {
        HashMap<Method, ClientInvoker> methodMap = new HashMap<Method, ClientInvoker>();
        for (Method method : clazz.getMethods()) {
            ClientInvoker invoker = null;
            Set<String> httpMethods = IsHttpMethod.getHttpMethods(method);
            if (httpMethods == null) {
                throw new RuntimeException("Method must be annotated with an http method annotation @GET, etc..");
            }
            if (httpMethods.size() != 1) {
                throw new RuntimeException("You may only annotate a method with only one http method annotation");
            }
            if (httpMethods.contains("GET")) {
                invoker = new GetInvoker(httpClient, clazz, method, providerFactory);
            } else if (httpMethods.contains("PUT")) {
                invoker = new PutInvoker(httpClient, clazz, method, providerFactory);
            } else if (httpMethods.contains("POST")) {
                invoker = new PostInvoker(httpClient, clazz, method, providerFactory);
            } else if (httpMethods.contains("DELETE")) {
                invoker = new DeleteInvoker(httpClient, clazz, method, providerFactory);
            } else {
                throw new RuntimeException("@" + httpMethods.iterator().next() + " is not supported yet");
            }
            invoker.setBaseUri(baseUri);
            methodMap.put(method, invoker);
        }
        Class[] intfs = new Class[]{clazz};
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), intfs, (InvocationHandler)new ClientProxy(methodMap));
    }
}

