/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.html;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import org.jboss.resteasy.plugins.providers.html.Renderable;
import org.jboss.resteasy.spi.InternalServerErrorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class View
implements Renderable {
    public static final String DEFAULT_MODEL_NAME = "model";
    protected String path;
    protected Map<String, Object> model = new HashMap<String, Object>();

    public View(String path) {
        this(path, null, null);
    }

    public View(String path, Object model) {
        this(path, model, DEFAULT_MODEL_NAME);
    }

    public View(String path, Object model, String modelName) {
        this.path = path;
        if (modelName != null) {
            this.setValue(modelName, model);
        }
    }

    private Object setValue(String variable, Object model) {
        return this.model.put(variable, model);
    }

    public String getPath() {
        return this.path;
    }

    private <T> T getFirst(Collection<T> values) {
        return values.isEmpty() ? null : (T)values.iterator().next();
    }

    public String getModelName() {
        return this.getFirst(this.model.keySet());
    }

    public Object getModel() {
        return this.getFirst(this.model.values());
    }

    public Map<String, Object> getModelMap() {
        return this.model;
    }

    @Override
    public void render(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, WebApplicationException {
        for (Map.Entry<String, Object> entry : this.model.entrySet()) {
            request.setAttribute(entry.getKey(), entry.getValue());
        }
        RequestDispatcher disp = request.getRequestDispatcher(this.path);
        if (disp == null) {
            throw new InternalServerErrorException("No dispatcher found for path '" + this.path + "'");
        }
        disp.forward((ServletRequest)request, (ServletResponse)response);
    }
}

