/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.api.validation;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.validation.ValidationException;
import org.jboss.resteasy.api.validation.ConstraintType;
import org.jboss.resteasy.api.validation.ResteasyConstraintViolation;
import org.jboss.resteasy.plugins.providers.validation.ViolationsContainer;

public class ResteasyViolationException
extends ValidationException {
    private static final long serialVersionUID = 2623733139912277260L;
    private Exception exception;
    private List<ResteasyConstraintViolation> fieldViolations = new ArrayList<ResteasyConstraintViolation>();
    private List<ResteasyConstraintViolation> propertyViolations = new ArrayList<ResteasyConstraintViolation>();
    private List<ResteasyConstraintViolation> classViolations = new ArrayList<ResteasyConstraintViolation>();
    private List<ResteasyConstraintViolation> parameterViolations = new ArrayList<ResteasyConstraintViolation>();
    private List<ResteasyConstraintViolation> returnValueViolations = new ArrayList<ResteasyConstraintViolation>();
    private List<ResteasyConstraintViolation> allViolations;
    private List<List<ResteasyConstraintViolation>> violationLists;

    public ResteasyViolationException(ViolationsContainer<?> container) {
        this.convertToStrings(container);
        this.exception = container.getException();
    }

    public ResteasyViolationException(String stringRep) {
        this.convertFromString(stringRep);
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public List<ResteasyConstraintViolation> getViolations() {
        if (this.allViolations == null) {
            this.allViolations = new ArrayList<ResteasyConstraintViolation>();
            this.allViolations.addAll(this.fieldViolations);
            this.allViolations.addAll(this.propertyViolations);
            this.allViolations.addAll(this.classViolations);
            this.allViolations.addAll(this.parameterViolations);
            this.allViolations.addAll(this.returnValueViolations);
        }
        return this.allViolations;
    }

    public List<ResteasyConstraintViolation> getFieldViolations() {
        return this.fieldViolations;
    }

    public List<ResteasyConstraintViolation> getPropertyViolations() {
        return this.propertyViolations;
    }

    public List<ResteasyConstraintViolation> getClassViolations() {
        return this.classViolations;
    }

    public List<ResteasyConstraintViolation> getParameterViolations() {
        return this.parameterViolations;
    }

    public List<ResteasyConstraintViolation> getReturnValueViolations() {
        return this.returnValueViolations;
    }

    public int size() {
        return this.getViolations().size();
    }

    public List<List<ResteasyConstraintViolation>> getViolationLists() {
        return this.violationLists;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (List<ResteasyConstraintViolation> violations : this.violationLists) {
            Iterator<ResteasyConstraintViolation> it2 = violations.iterator();
            while (it2.hasNext()) {
                sb.append(it2.next().toString()).append('\r');
            }
        }
        return sb.toString();
    }

    protected void convertToStrings(ViolationsContainer container) {
        if (this.violationLists != null) {
            return;
        }
        this.violationLists = new ArrayList<List<ResteasyConstraintViolation>>();
        this.fieldViolations = container.getFieldViolations();
        this.propertyViolations = container.getPropertyViolations();
        this.classViolations = container.getClassViolations();
        this.parameterViolations = container.getParameterViolations();
        this.returnValueViolations = container.getReturnValueViolations();
        this.violationLists.add(this.fieldViolations);
        this.violationLists.add(this.propertyViolations);
        this.violationLists.add(this.classViolations);
        this.violationLists.add(this.parameterViolations);
        this.violationLists.add(this.returnValueViolations);
    }

    protected void convertFromString(String stringRep) {
        ByteArrayInputStream is = new ByteArrayInputStream(stringRep.getBytes());
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        try {
            boolean index = false;
            String line = br.readLine();
            while (line != null) {
                ConstraintType.Type type = ConstraintType.Type.valueOf((String)line.substring(1, line.length() - 1));
                line = br.readLine();
                String path = line.substring(1, line.length() - 1);
                line = br.readLine();
                String message = line.substring(1, line.length() - 1);
                line = br.readLine();
                String value = line.substring(1, line.length() - 1);
                ResteasyConstraintViolation rcv = new ResteasyConstraintViolation(type, path, message, value);
                switch (type) {
                    case FIELD: {
                        this.fieldViolations.add(rcv);
                        break;
                    }
                    case PROPERTY: {
                        this.propertyViolations.add(rcv);
                        break;
                    }
                    case CLASS: {
                        this.classViolations.add(rcv);
                        break;
                    }
                    case PARAMETER: {
                        this.parameterViolations.add(rcv);
                        break;
                    }
                    case RETURN_VALUE: {
                        this.returnValueViolations.add(rcv);
                        break;
                    }
                    default: {
                        throw new RuntimeException("unexpected violation type: " + type);
                    }
                }
                index = false;
                line = br.readLine();
                line = br.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse ResteasyViolationException");
        }
        this.violationLists = new ArrayList<List<ResteasyConstraintViolation>>();
        this.violationLists.add(this.fieldViolations);
        this.violationLists.add(this.propertyViolations);
        this.violationLists.add(this.classViolations);
        this.violationLists.add(this.parameterViolations);
        this.violationLists.add(this.returnValueViolations);
    }

    protected int getField(int start, String line) {
        int beginning = line.indexOf(91, start);
        if (beginning == -1) {
            throw new RuntimeException("ResteasyViolationException has invalid format: " + line);
        }
        int index = beginning;
        int bracketCount = 1;
        while (++index < line.length()) {
            char c = line.charAt(index);
            if (c == '[') {
                ++bracketCount;
            } else if (c == ']') {
                --bracketCount;
            }
            if (bracketCount != 0) continue;
            break;
        }
        if (bracketCount != 0) {
            throw new RuntimeException("ResteasyViolationException has invalid format: " + line);
        }
        return index;
    }
}

