/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.validation.hibernate;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.metadata.BeanDescriptor;
import org.hibernate.validator.method.MethodValidator;
import org.jboss.resteasy.plugins.providers.validation.ConstraintTypeUtil;
import org.jboss.resteasy.plugins.providers.validation.GeneralValidator;
import org.jboss.resteasy.plugins.validation.hibernate.ConstraintTypeUtil10;
import org.jboss.resteasy.spi.validation.ConstraintType;
import org.jboss.resteasy.spi.validation.DoNotValidateRequest;
import org.jboss.resteasy.spi.validation.ResteasyConstraintViolation;
import org.jboss.resteasy.spi.validation.ValidateRequest;
import org.jboss.resteasy.util.FindAnnotation;

public class GeneralValidatorImpl
implements GeneralValidator {
    private Validator validator;
    private MethodValidator methodValidator;
    private ConstraintTypeUtil util = new ConstraintTypeUtil10();

    public GeneralValidatorImpl(Validator validator, MethodValidator methodValidator) {
        this.validator = validator;
        this.methodValidator = methodValidator;
    }

    public <T> Set<ResteasyConstraintViolation> validate(T object, Class<?> ... groups) {
        Set cvs = this.validator.validate(object, (Class[])groups);
        HashSet<ResteasyConstraintViolation> rcvs = new HashSet<ResteasyConstraintViolation>();
        for (ConstraintViolation cv : cvs) {
            ConstraintType.Type ct = this.util.getConstraintType((Object)cv);
            rcvs.add(new ResteasyConstraintViolation(ct, cv.getPropertyPath().toString(), cv.getMessage(), cv.getInvalidValue().toString()));
        }
        return rcvs;
    }

    public <T> Set<ResteasyConstraintViolation> validateProperty(T object, String propertyName, Class<?> ... groups) {
        Set cvs = this.validator.validateProperty(object, propertyName, (Class[])groups);
        HashSet<ResteasyConstraintViolation> rcvs = new HashSet<ResteasyConstraintViolation>();
        for (ConstraintViolation cv : cvs) {
            ConstraintType.Type ct = this.util.getConstraintType((Object)cv);
            rcvs.add(new ResteasyConstraintViolation(ct, cv.getPropertyPath().toString(), cv.getMessage(), cv.getInvalidValue().toString()));
        }
        return rcvs;
    }

    public <T> Set<ResteasyConstraintViolation> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        Set cvs = this.validator.validateValue(beanType, propertyName, value, (Class[])groups);
        HashSet<ResteasyConstraintViolation> rcvs = new HashSet<ResteasyConstraintViolation>();
        for (ConstraintViolation cv : cvs) {
            ConstraintType.Type ct = this.util.getConstraintType((Object)cv);
            rcvs.add(new ResteasyConstraintViolation(ct, cv.getPropertyPath().toString(), cv.getMessage(), cv.getInvalidValue().toString()));
        }
        return rcvs;
    }

    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return this.validator.getConstraintsForClass(clazz);
    }

    public <T> T unwrap(Class<T> type) {
        return (T)this.validator.unwrap(type);
    }

    public <T> Set<ResteasyConstraintViolation> validateParameter(T object, Method method, Object parameterValue, int parameterIndex, Class<?> ... groups) {
        Set cvs = this.methodValidator.validateParameter(object, method, parameterValue, parameterIndex, (Class[])groups);
        HashSet<ResteasyConstraintViolation> rcvs = new HashSet<ResteasyConstraintViolation>();
        for (ConstraintViolation cv : cvs) {
            ConstraintType.Type ct = this.util.getConstraintType((Object)cv);
            rcvs.add(new ResteasyConstraintViolation(ct, cv.getPropertyPath().toString(), cv.getMessage(), cv.getInvalidValue().toString()));
        }
        return rcvs;
    }

    public <T> Set<ResteasyConstraintViolation> validateAllParameters(T object, Method method, Object[] parameterValues, Class<?> ... groups) {
        Set cvs = this.methodValidator.validateAllParameters(object, method, parameterValues, (Class[])groups);
        HashSet<ResteasyConstraintViolation> rcvs = new HashSet<ResteasyConstraintViolation>();
        for (ConstraintViolation cv : cvs) {
            ConstraintType.Type ct = this.util.getConstraintType((Object)cv);
            rcvs.add(new ResteasyConstraintViolation(ct, cv.getPropertyPath().toString(), cv.getMessage(), cv.getInvalidValue().toString()));
        }
        return rcvs;
    }

    public <T> Set<ResteasyConstraintViolation> validateReturnValue(T object, Method method, Object returnValue, Class<?> ... groups) {
        Set cvs = this.methodValidator.validateReturnValue(object, method, returnValue, (Class[])groups);
        HashSet<ResteasyConstraintViolation> rcvs = new HashSet<ResteasyConstraintViolation>();
        for (ConstraintViolation cv : cvs) {
            ConstraintType.Type ct = this.util.getConstraintType((Object)cv);
            rcvs.add(new ResteasyConstraintViolation(ct, cv.getPropertyPath().toString(), cv.getMessage(), cv.getInvalidValue().toString()));
        }
        return rcvs;
    }

    public boolean isValidatable(Class<?> clazz) {
        ValidateRequest resourceValidateRequest = (ValidateRequest)FindAnnotation.findAnnotation((Annotation[])clazz.getAnnotations(), ValidateRequest.class);
        DoNotValidateRequest doNotValidateRequest = (DoNotValidateRequest)FindAnnotation.findAnnotation((Annotation[])clazz.getAnnotations(), DoNotValidateRequest.class);
        return resourceValidateRequest != null && doNotValidateRequest == null;
    }

    public boolean isMethodValidatable(Method m) {
        ValidateRequest resourceValidateRequest = (ValidateRequest)FindAnnotation.findAnnotation((Annotation[])m.getDeclaringClass().getAnnotations(), ValidateRequest.class);
        ValidateRequest methodValidateRequest = (ValidateRequest)FindAnnotation.findAnnotation((Annotation[])m.getAnnotations(), ValidateRequest.class);
        DoNotValidateRequest doNotValidateRequest = (DoNotValidateRequest)FindAnnotation.findAnnotation((Annotation[])m.getAnnotations(), DoNotValidateRequest.class);
        return (resourceValidateRequest != null || methodValidateRequest != null) && doNotValidateRequest == null;
    }
}

