/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.validation.hibernate;

import java.lang.reflect.Method;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import org.hibernate.validator.method.MethodConstraintViolation;
import org.jboss.resteasy.plugins.providers.validation.ConstraintTypeUtil;
import org.jboss.resteasy.spi.validation.ConstraintType;

public class ConstraintTypeUtil10
implements ConstraintTypeUtil {
    public ConstraintType.Type getConstraintType(Object o) {
        if (!(o instanceof ConstraintViolation)) {
            throw new RuntimeException("unknown object passed as constraint violation: " + o);
        }
        ConstraintViolation v = (ConstraintViolation)ConstraintViolation.class.cast(o);
        if (v instanceof MethodConstraintViolation) {
            MethodConstraintViolation mv = (MethodConstraintViolation)MethodConstraintViolation.class.cast(v);
            return mv.getKind() == MethodConstraintViolation.Kind.PARAMETER ? ConstraintType.Type.PARAMETER : ConstraintType.Type.RETURN_VALUE;
        }
        Object b = v.getRootBean();
        String fieldName = null;
        for (Path.Node node : v.getPropertyPath()) {
            fieldName = node.getName();
            if (fieldName != null) continue;
            return ConstraintType.Type.CLASS;
        }
        String getterName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        try {
            ConstraintTypeUtil10.getMethod(v.getLeafBean().getClass(), getterName);
            return ConstraintType.Type.PROPERTY;
        }
        catch (NoSuchMethodException e) {
            return ConstraintType.Type.FIELD;
        }
    }

    private static Method getMethod(Class<?> clazz, String methodName) throws NoSuchMethodException {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        while (method == null && (clazz = clazz.getSuperclass()) != null) {
            try {
                method = clazz.getDeclaredMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        if (method == null) {
            throw new NoSuchMethodException(methodName);
        }
        return method;
    }

    private static Class<?> getRepresentedClass(Class<?> clazz, Object target) {
        Method method;
        try {
            method = clazz.getDeclaredMethod("getTargetClass", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return clazz;
        }
        try {
            return (Class)Class.class.cast(method.invoke(target, new Object[0]));
        }
        catch (Exception e) {
            return clazz;
        }
    }
}

