/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.guice;

import com.google.inject.Module;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jboss.resteasy.plugins.guice.ModuleProcessor;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiceResteasyBootstrapServletContextListener
extends ResteasyBootstrap
implements ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(GuiceResteasyBootstrapServletContextListener.class);

    public void contextInitialized(ServletContextEvent event) {
        super.contextInitialized(event);
        ServletContext context = event.getServletContext();
        Registry registry = (Registry)context.getAttribute(Registry.class.getName());
        ResteasyProviderFactory providerFactory = (ResteasyProviderFactory)context.getAttribute(ResteasyProviderFactory.class.getName());
        ModuleProcessor processor = new ModuleProcessor(registry, providerFactory);
        List<Module> modules = this.getModules(context);
        processor.process(modules);
    }

    private List<Module> getModules(ServletContext context) {
        ArrayList<Module> result = new ArrayList<Module>();
        String modulesString = context.getInitParameter("resteasy.guice.modules");
        if (modulesString != null) {
            String[] moduleStrings;
            for (String moduleString : moduleStrings = modulesString.trim().split(",")) {
                try {
                    logger.info("found module: {}", (Object)moduleString);
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(moduleString.trim());
                    Module module = (Module)clazz.newInstance();
                    result.add(module);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return result;
    }

    public void contextDestroyed(ServletContextEvent event) {
    }
}

