/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.embedded.test.core.validate;

import dev.resteasy.junit.extension.annotations.RequestPath;
import dev.resteasy.junit.extension.annotations.RestBootstrap;
import jakarta.validation.constraints.Size;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Response;
import java.util.Set;
import org.jboss.resteasy.api.validation.ViolationReport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@RestBootstrap(value=TestApp.class)
public class NonCDIValidatorFactoryTest {
    @Test
    public void testValidate(@RequestPath(value="/test/validate/x") WebTarget target) {
        Invocation.Builder request = target.request();
        Response response = request.get();
        Assertions.assertEquals((int)400, (int)response.getStatus());
        String header = response.getHeaderString("validation-exception");
        Assertions.assertNotNull((Object)header, (String)"Validation header is missing");
        Assertions.assertTrue((boolean)Boolean.parseBoolean(header), (String)"Wrong validation header");
        String entity = (String)response.readEntity(String.class);
        ViolationReport r = new ViolationReport(entity);
        NonCDIValidatorFactoryTest.countViolations(r, 0, 0, 1, 0);
    }

    private static void countViolations(ViolationReport report, int propertyCount, int classCount, int parameterCount, int returnValueCount) {
        Assertions.assertEquals((int)propertyCount, (int)report.getPropertyViolations().size(), () -> String.format("Expected %d property violations, found %d: %s", propertyCount, report.getPropertyViolations().size(), report.getPropertyViolations()));
        Assertions.assertEquals((int)classCount, (int)report.getClassViolations().size(), () -> String.format("Expected %d class violations, found %d: %s", classCount, report.getClassViolations().size(), report.getClassViolations()));
        Assertions.assertEquals((int)parameterCount, (int)report.getParameterViolations().size(), () -> String.format("Expected %d parameter violations, found %d: %s", parameterCount, report.getParameterViolations().size(), report.getParameterViolations()));
        Assertions.assertEquals((int)returnValueCount, (int)report.getReturnValueViolations().size(), () -> String.format("Expected %d return value violations, found %d: %s", returnValueCount, report.getReturnValueViolations().size(), report.getReturnValueViolations()));
    }

    @Path(value="test")
    public static class TestResource {
        @GET
        @Path(value="validate/{n}")
        @Produces(value={"text/plain"})
        public Response string(@Size(min=3) @Size(min=3) String s) {
            return Response.ok((Object)"ok").build();
        }
    }

    public static class TestApp
    extends Application {
        public Set<Class<?>> getClasses() {
            return Set.of(TestResource.class);
        }
    }
}

