/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.smime;

import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateEncodingException;
import java.util.concurrent.CompletionStage;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.jboss.resteasy.plugins.providers.ProviderHelper;
import org.jboss.resteasy.security.BouncyIntegration;
import org.jboss.resteasy.security.doseta.i18n.Messages;
import org.jboss.resteasy.security.smime.SignedOutput;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.AsyncMessageBodyWriter;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.spi.WriterException;

@Provider
@Produces(value={"application/pkcs7-signature"})
public class PKCS7SignatureWriter
implements AsyncMessageBodyWriter<SignedOutput> {
    @Context
    protected Providers providers;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return SignedOutput.class.isAssignableFrom(type);
    }

    public long getSize(SignedOutput smimeOutput, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(SignedOutput out, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException, WebApplicationException {
        try {
            byte[] encoded = PKCS7SignatureWriter.sign(this.providers, out);
            headers.putSingle((Object)"Content-Type", (Object)"application/pkcs7-signature;micalg=\"sha1\"");
            os.write(encoded);
        }
        catch (Exception e) {
            throw new WriterException((Throwable)e);
        }
    }

    public CompletionStage<Void> asyncWriteTo(SignedOutput out, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> headers, AsyncOutputStream entityStream) {
        try {
            byte[] encoded = PKCS7SignatureWriter.sign(this.providers, out);
            headers.putSingle((Object)"Content-Type", (Object)"application/pkcs7-signature;micalg=\"sha1\"");
            return entityStream.asyncWrite(encoded);
        }
        catch (Exception e) {
            return ProviderHelper.completedException((Throwable)new WriterException((Throwable)e));
        }
    }

    public static byte[] sign(Providers providers, SignedOutput out) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, CMSException, OperatorCreationException, CertificateEncodingException {
        ByteArrayOutputStream bodyOs = new ByteArrayOutputStream();
        MessageBodyWriter writer = providers.getMessageBodyWriter(out.getType(), out.getGenericType(), null, out.getMediaType());
        if (writer == null) {
            throw new WriterException(Messages.MESSAGES.failedToFindWriter(out.getType().getName()));
        }
        MultivaluedMapImpl bodyHeaders = new MultivaluedMapImpl();
        bodyHeaders.add((Object)"Content-Type", (Object)out.getMediaType().toString());
        writer.writeTo(out.getEntity(), out.getType(), out.getGenericType(), null, out.getMediaType(), (MultivaluedMap)bodyHeaders, (OutputStream)bodyOs);
        CMSSignedDataGenerator signGen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider("BC").build(out.getPrivateKey());
        signGen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).build(sha1Signer, out.getCertificate()));
        CMSProcessableByteArray content = new CMSProcessableByteArray(bodyOs.toByteArray());
        CMSSignedData signedData = signGen.generate((CMSTypedData)content, true);
        return signedData.getEncoded();
    }

    static {
        BouncyIntegration.init();
    }
}

