/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.doseta;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.ws.rs.core.SecurityContext;
import org.jboss.resteasy.security.doseta.DKIMSignature;
import org.jboss.resteasy.security.doseta.KeyRepository;
import org.jboss.resteasy.security.doseta.KeyStoreKeyRepository;
import org.jboss.resteasy.security.doseta.i18n.LogMessages;
import org.jboss.resteasy.security.doseta.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.Base64;
import org.jboss.resteasy.util.ParameterParser;

public class DosetaKeyRepository
implements KeyRepository {
    protected ConcurrentHashMap<String, CacheEntry<PrivateKey>> privateCache = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, CacheEntry<PublicKey>> publicCache = new ConcurrentHashMap();
    protected KeyStoreKeyRepository keyStore;
    protected String defaultPrivateDomain;
    protected boolean useDns = false;
    protected boolean userPrincipalAsPrivateSelector = false;
    protected String dnsUri;
    protected long cacheTimeout = 3600000L;
    protected String keyStorePath;
    protected String keyStoreFile;
    protected String keyStorePassword;

    public void start() {
        if (this.keyStore == null) {
            if (this.keyStoreFile != null) {
                try {
                    this.keyStore = new KeyStoreKeyRepository(this.keyStoreFile, this.keyStorePassword);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.keyStorePath != null) {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.keyStorePath.trim());
                if (is == null) {
                    throw new RuntimeException(Messages.MESSAGES.unableToFindKeyStore(this.keyStorePath));
                }
                this.keyStore = new KeyStoreKeyRepository(is, this.keyStorePassword);
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public String getDefaultPrivateSelector() {
        SecurityContext securityContext;
        if (this.userPrincipalAsPrivateSelector && (securityContext = (SecurityContext)ResteasyProviderFactory.getContextData(SecurityContext.class)) != null) {
            return securityContext.getUserPrincipal().getName();
        }
        return null;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public KeyStoreKeyRepository getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStoreKeyRepository keyStore) {
        this.keyStore = keyStore;
    }

    @Override
    public String getDefaultPrivateDomain() {
        return this.defaultPrivateDomain;
    }

    public void setDefaultPrivateDomain(String defaultPrivateDomain) {
        this.defaultPrivateDomain = defaultPrivateDomain;
    }

    public boolean isUseDns() {
        return this.useDns;
    }

    public void setUseDns(boolean useDns) {
        this.useDns = useDns;
    }

    public boolean isUserPrincipalAsPrivateSelector() {
        return this.userPrincipalAsPrivateSelector;
    }

    public void setUserPrincipalAsPrivateSelector(boolean userPrincipalAsPrivateSelector) {
        this.userPrincipalAsPrivateSelector = userPrincipalAsPrivateSelector;
    }

    public String getDnsUri() {
        return this.dnsUri;
    }

    public void setDnsUri(String dnsUri) {
        this.dnsUri = dnsUri;
    }

    public long getCacheTimeout() {
        return this.cacheTimeout;
    }

    public void setCacheTimeout(long cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
    }

    protected void addPrivate(String alias, PrivateKey key) {
        this.privateCache.put(alias, new CacheEntry<PrivateKey>(key));
    }

    protected void addPublic(String alias, PublicKey key) {
        this.publicCache.put(alias, new CacheEntry<PublicKey>(key));
    }

    protected PrivateKey getPrivateCache(String alias) {
        CacheEntry<PrivateKey> entry = this.privateCache.get(alias);
        if (entry == null) {
            return null;
        }
        if (entry.isStale()) {
            this.privateCache.remove(alias, entry);
            return null;
        }
        return (PrivateKey)entry.key;
    }

    protected PublicKey getPublicCache(String alias) {
        CacheEntry<PublicKey> entry = this.publicCache.get(alias);
        if (entry == null) {
            return null;
        }
        if (entry.isStale()) {
            this.publicCache.remove(alias, entry);
            return null;
        }
        return (PublicKey)entry.key;
    }

    public String getAlias(DKIMSignature header) {
        StringBuffer buf = new StringBuffer();
        String selector = header.getSelector();
        if (selector != null) {
            buf.append(selector.trim()).append(".");
        }
        buf.append("_domainKey.");
        String domain = header.getDomain();
        if (domain == null) {
            throw new RuntimeException(Messages.MESSAGES.domainAttributeIsRequired());
        }
        buf.append(domain);
        return buf.toString();
    }

    @Override
    public PrivateKey findPrivateKey(DKIMSignature header) {
        String alias = this.getAlias(header);
        if (alias == null) {
            return null;
        }
        PrivateKey key = this.getPrivateCache(alias);
        if (key != null) {
            return key;
        }
        if (this.keyStore != null && (key = this.keyStore.getPrivateKey(alias)) != null) {
            this.addPrivate(alias, key);
        }
        return key;
    }

    @Override
    public PublicKey findPublicKey(DKIMSignature header) {
        String alias = this.getAlias(header);
        if (alias == null) {
            return null;
        }
        PublicKey key = this.getPublicCache(alias);
        if (key != null) {
            return key;
        }
        if (this.keyStore != null && (key = this.keyStore.getPublicKey(alias)) != null) {
            this.addPublic(alias, key);
        }
        if (this.useDns) {
            key = this.findFromDns(alias);
            this.addPublic(alias, key);
        }
        return key;
    }

    protected PublicKey findFromDns(String alias) {
        PublicKey key;
        if (LogMessages.LOGGER.isDebugEnabled()) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.checkDNS(alias));
        }
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            if (this.dnsUri != null) {
                env.put("java.naming.provider.url", this.dnsUri);
            }
            InitialDirContext dnsContext = new InitialDirContext(env);
            Attributes attrs1 = dnsContext.getAttributes(alias, new String[]{"TXT"});
            Attribute txtrecord = attrs1.get("txt");
            String record = txtrecord.get().toString();
            dnsContext.close();
            if (LogMessages.LOGGER.isDebugEnabled()) {
                LogMessages.LOGGER.debug(Messages.MESSAGES.dnsRecordFound(record));
            }
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map keyEntry = parser.parse(record, ';');
            String type = (String)keyEntry.get("k");
            if (type != null && !type.toLowerCase().equals("rsa")) {
                throw new RuntimeException(Messages.MESSAGES.unsupportedKeyType(type));
            }
            String pem = (String)keyEntry.get("p");
            if (pem == null) {
                throw new RuntimeException(Messages.MESSAGES.noPEntry());
            }
            if (LogMessages.LOGGER.isDebugEnabled()) {
                LogMessages.LOGGER.debug(Messages.MESSAGES.pem(pem));
            }
            byte[] der = Base64.decode((String)pem);
            X509EncodedKeySpec spec = new X509EncodedKeySpec(der);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            key = kf.generatePublic(spec);
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.MESSAGES.failedToFindPublicKey(alias), e);
        }
        return key;
    }

    protected class CacheEntry<T> {
        public long time = System.currentTimeMillis();
        public T key;

        protected CacheEntry(T key) {
            this.key = key;
        }

        public boolean isStale() {
            return this.time + DosetaKeyRepository.this.cacheTimeout >= System.currentTimeMillis();
        }
    }
}

