/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal.proxy.processors;

import java.util.Collection;

public abstract class AbstractCollectionProcessor<T> {
    protected String paramName;

    public AbstractCollectionProcessor(String paramName) {
        this.paramName = paramName;
    }

    protected abstract T apply(T var1, Object var2);

    public T buildIt(T target, Object object) {
        if (object == null) {
            return target;
        }
        if (object instanceof Collection) {
            for (Object obj : (Collection)object) {
                target = this.apply(target, obj);
            }
        } else if (object.getClass().isArray()) {
            if (object.getClass().getComponentType().isPrimitive()) {
                Class<?> componentType = object.getClass().getComponentType();
                if (componentType.equals(Boolean.TYPE)) {
                    boolean[] blArray = (boolean[])object;
                    int n = blArray.length;
                    for (int i = 0; i < n; ++i) {
                        Boolean bool = blArray[i];
                        target = this.apply(target, bool.toString());
                    }
                } else if (componentType.equals(Byte.TYPE)) {
                    byte[] byArray = (byte[])object;
                    int n = byArray.length;
                    for (int i = 0; i < n; ++i) {
                        Byte val = byArray[i];
                        target = this.apply(target, val.toString());
                    }
                } else if (componentType.equals(Short.TYPE)) {
                    short[] sArray = (short[])object;
                    int n = sArray.length;
                    for (int i = 0; i < n; ++i) {
                        Short val = sArray[i];
                        target = this.apply(target, val.toString());
                    }
                } else if (componentType.equals(Integer.TYPE)) {
                    int[] nArray = (int[])object;
                    int n = nArray.length;
                    for (int i = 0; i < n; ++i) {
                        Integer val = nArray[i];
                        target = this.apply(target, val.toString());
                    }
                } else if (componentType.equals(Long.TYPE)) {
                    long[] lArray = (long[])object;
                    int n = lArray.length;
                    for (int i = 0; i < n; ++i) {
                        Long val = lArray[i];
                        target = this.apply(target, val.toString());
                    }
                } else if (componentType.equals(Float.TYPE)) {
                    float[] fArray = (float[])object;
                    int n = fArray.length;
                    for (int i = 0; i < n; ++i) {
                        Float val = Float.valueOf(fArray[i]);
                        target = this.apply(target, val.toString());
                    }
                } else if (componentType.equals(Double.TYPE)) {
                    double[] dArray = (double[])object;
                    int n = dArray.length;
                    for (int i = 0; i < n; ++i) {
                        Double val = dArray[i];
                        target = this.apply(target, val.toString());
                    }
                }
            } else {
                Object[] objs;
                for (Object obj : objs = (Object[])object) {
                    target = this.apply(target, obj);
                }
            }
        } else {
            target = this.apply(target, object);
        }
        return target;
    }
}

