/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs;

import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.jboss.resteasy.client.jaxrs.engines.PassthroughTrustManager;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.spi.NotImplementedYetException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ResteasyClientBuilder
extends ClientBuilder {
    protected KeyStore truststore;
    protected KeyStore clientKeyStore;
    protected String clientPrivateKeyPassword;
    protected boolean disableTrustManager;
    protected HostnameVerificationPolicy policy = HostnameVerificationPolicy.WILDCARD;
    protected ResteasyProviderFactory providerFactory;
    protected ExecutorService asyncExecutor;
    protected SSLContext sslContext;
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected ClientHttpEngine httpEngine;
    protected int connectionPoolSize;
    protected int maxPooledPerRoute = 0;
    protected long connectionTTL = -1L;
    protected TimeUnit connectionTTLUnit = TimeUnit.MILLISECONDS;

    public ResteasyClientBuilder providerFactory(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
        return this;
    }

    public ResteasyClientBuilder asyncExecutor(ExecutorService asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
        return this;
    }

    public ResteasyClientBuilder connectionTTL(long ttl, TimeUnit unit) {
        this.connectionTTL = ttl;
        this.connectionTTLUnit = unit;
        return this;
    }

    public ResteasyClientBuilder maxPooledPerRoute(int maxPooledPerRoute) {
        this.maxPooledPerRoute = maxPooledPerRoute;
        return this;
    }

    public ResteasyClientBuilder connectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
        return this;
    }

    public ResteasyClientBuilder disableTrustManager() {
        this.disableTrustManager = true;
        return this;
    }

    public ResteasyClientBuilder hostnameVerification(HostnameVerificationPolicy policy) {
        this.policy = policy;
        return this;
    }

    public ResteasyClientBuilder httpEngine(ClientHttpEngine httpEngine) {
        this.httpEngine = httpEngine;
        return this;
    }

    public ResteasyClientBuilder sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public ResteasyClientBuilder trustStore(KeyStore truststore) {
        this.truststore = truststore;
        return this;
    }

    public ResteasyClientBuilder keyStore(KeyStore keyStore, String password) {
        this.clientKeyStore = keyStore;
        this.clientPrivateKeyPassword = password;
        return this;
    }

    public ResteasyClientBuilder keyStore(KeyStore keyStore, char[] password) {
        this.clientKeyStore = keyStore;
        this.clientPrivateKeyPassword = new String(password);
        return this;
    }

    public ResteasyClientBuilder property(String name, Object value) {
        this.getProviderFactory().property(name, value);
        return this;
    }

    protected ResteasyProviderFactory getProviderFactory() {
        if (this.providerFactory == null) {
            this.providerFactory = new ResteasyProviderFactory();
            RegisterBuiltin.register((ResteasyProviderFactory)this.providerFactory);
        }
        return this.providerFactory;
    }

    public ResteasyClient build() {
        ClientConfiguration config = new ClientConfiguration(this.getProviderFactory());
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            config.property(entry.getKey(), entry.getValue());
        }
        if (this.asyncExecutor == null) {
            this.asyncExecutor = Executors.newFixedThreadPool(10);
        }
        if (this.httpEngine == null) {
            this.httpEngine = this.initDefaultEngine();
        }
        return new ResteasyClient(this.httpEngine, this.asyncExecutor, config);
    }

    protected ClientHttpEngine initDefaultEngine() {
        DefaultHttpClient httpClient = null;
        AllowAllHostnameVerifier verifier = null;
        switch (this.policy) {
            case ANY: {
                verifier = new AllowAllHostnameVerifier();
                break;
            }
            case WILDCARD: {
                verifier = new BrowserCompatHostnameVerifier();
                break;
            }
            case STRICT: {
                verifier = new StrictHostnameVerifier();
            }
        }
        try {
            SSLSocketFactory sslsf = null;
            if (this.disableTrustManager) {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, new TrustManager[]{new PassthroughTrustManager()}, new SecureRandom());
                sslsf = new SSLSocketFactory(sslContext);
                sslsf.setHostnameVerifier((X509HostnameVerifier)new AllowAllHostnameVerifier());
            } else if (this.sslContext != null) {
                sslsf = new SSLSocketFactory(this.sslContext);
                sslsf.setHostnameVerifier((X509HostnameVerifier)verifier);
            } else if (this.clientKeyStore != null || this.truststore != null) {
                sslsf = new SSLSocketFactory(this.clientKeyStore, this.clientPrivateKeyPassword, this.truststore);
                sslsf.setHostnameVerifier((X509HostnameVerifier)verifier);
            } else {
                if (this.connectionPoolSize <= 0) {
                    return new ApacheHttpClient4Engine();
                }
                sslsf = SSLSocketFactory.getSocketFactory();
                sslsf.setHostnameVerifier((X509HostnameVerifier)verifier);
            }
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
            Scheme httpsScheme = new Scheme("https", (SocketFactory)sslsf, 443);
            registry.register(httpsScheme);
            SingleClientConnManager cm = null;
            if (this.connectionPoolSize > 0) {
                ThreadSafeClientConnManager tcm = new ThreadSafeClientConnManager(registry, this.connectionTTL, this.connectionTTLUnit);
                tcm.setMaxTotal(this.connectionPoolSize);
                if (this.maxPooledPerRoute == 0) {
                    this.maxPooledPerRoute = this.connectionPoolSize;
                }
                tcm.setDefaultMaxPerRoute(this.maxPooledPerRoute);
                cm = tcm;
            } else {
                cm = new SingleClientConnManager(registry);
            }
            httpClient = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)new BasicHttpParams());
            return new ApacheHttpClient4Engine((HttpClient)httpClient, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ClientBuilder hostnameVerifier(HostnameVerifier verifier) {
        throw new NotImplementedYetException();
    }

    public Configuration getConfiguration() {
        return this.getProviderFactory().getConfiguration();
    }

    public ClientBuilder register(Class<?> componentClass) {
        this.getProviderFactory().register(componentClass);
        return this;
    }

    public ClientBuilder register(Class<?> componentClass, int priority) {
        this.getProviderFactory().register(componentClass, priority);
        return this;
    }

    public ClientBuilder register(Class<?> componentClass, Class<?> ... contracts) {
        this.getProviderFactory().register(componentClass, (Class[])contracts);
        return this;
    }

    public ClientBuilder register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.getProviderFactory().register(componentClass, contracts);
        return this;
    }

    public ClientBuilder register(Object component) {
        this.getProviderFactory().register(component);
        return this;
    }

    public ClientBuilder register(Object component, int priority) {
        this.getProviderFactory().register(component, priority);
        return this;
    }

    public ClientBuilder register(Object component, Class<?> ... contracts) {
        this.getProviderFactory().register(component, (Class[])contracts);
        return this;
    }

    public ClientBuilder register(Object component, Map<Class<?>, Integer> contracts) {
        this.getProviderFactory().register(component, contracts);
        return this;
    }

    public ClientBuilder replaceWith(Configuration config) {
        this.getProviderFactory().replaceWith(config);
        return this;
    }

    public static enum HostnameVerificationPolicy {
        ANY,
        WILDCARD,
        STRICT;

    }
}

