/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.Configuration;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.spi.HeaderValueProcessor;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ClientConfiguration
implements Configuration,
Providers,
HeaderValueProcessor {
    protected ResteasyProviderFactory providerFactory;

    public ClientConfiguration(ResteasyProviderFactory factory) {
        if (factory instanceof ThreadLocalResteasyProviderFactory) {
            factory = ((ThreadLocalResteasyProviderFactory)factory).getDelegate();
        }
        this.providerFactory = new ResteasyProviderFactory(factory);
    }

    public ClientConfiguration(ClientConfiguration parent) {
        this(parent.getProviderFactory());
        this.setProperties(parent.getProperties());
    }

    protected ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }

    public Map<String, Object> getMutableProperties() {
        return this.providerFactory.getMutableProperties();
    }

    public String toHeaderString(Object object) {
        return this.providerFactory.toHeaderString(object);
    }

    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.providerFactory.getMessageBodyWriter(type, genericType, annotations, mediaType);
    }

    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.providerFactory.getMessageBodyReader(type, genericType, annotations, mediaType);
    }

    public WriterInterceptor[] getWriterInterceptors(Class declaring, AccessibleObject target) {
        return (WriterInterceptor[])this.providerFactory.getClientWriterInterceptorRegistry().postMatch(declaring, target);
    }

    public ReaderInterceptor[] getReaderInterceptors(Class declaring, AccessibleObject target) {
        return (ReaderInterceptor[])this.providerFactory.getClientReaderInterceptorRegistry().postMatch(declaring, target);
    }

    public ClientRequestFilter[] getRequestFilters(Class declaring, AccessibleObject target) {
        return (ClientRequestFilter[])this.providerFactory.getClientRequestFilters().postMatch(declaring, target);
    }

    public ClientResponseFilter[] getResponseFilters(Class declaring, AccessibleObject target) {
        return (ClientResponseFilter[])this.providerFactory.getClientResponseFilters().postMatch(declaring, target);
    }

    public Set<DynamicFeature> getDynamicFeatures() {
        return this.providerFactory.getClientDynamicFeatures();
    }

    public String toString(Object object) {
        return this.providerFactory.toString(object, object.getClass(), null, null);
    }

    public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> type) {
        return this.providerFactory.getExceptionMapper(type);
    }

    public <T> ContextResolver<T> getContextResolver(Class<T> contextType, MediaType mediaType) {
        return this.providerFactory.getContextResolver(contextType, mediaType);
    }

    public Map<String, Object> getProperties() {
        return this.providerFactory.getProperties();
    }

    public Object getProperty(String name) {
        return this.providerFactory.getProperty(name);
    }

    public Collection<Feature> getEnabledFeatures() {
        return this.providerFactory.getEnabledFeatures();
    }

    public Set<Class<?>> getFeatureClasses() {
        return this.providerFactory.getFeatureClasses();
    }

    public Set<Object> getFeatureInstances() {
        return this.providerFactory.getFeatureInstances();
    }

    public Set<Class<?>> getProviderClasses() {
        return this.providerFactory.getProviderClasses();
    }

    public Set<Object> getProviderInstances() {
        return this.providerFactory.getProviderInstances();
    }

    public Configuration updateFrom(Configurable configuration) {
        this.providerFactory = new ResteasyProviderFactory();
        this.setProperties((Map<String, ? extends Object>)configuration.getProperties());
        for (Class c : configuration.getProviderClasses()) {
            this.register(c);
        }
        for (Object obj : configuration.getProviderInstances()) {
            this.register(obj);
        }
        return this;
    }

    public Configuration register(Class<?> providerClass) {
        this.providerFactory.register(providerClass);
        return this;
    }

    public Configuration register(Object provider) {
        this.providerFactory.register(provider);
        return this;
    }

    public Configuration register(Class<?> providerClass, int bindingPriority) {
        this.providerFactory.register(providerClass, bindingPriority);
        return this;
    }

    public <T> Configuration register(Class<T> providerClass, Class<? super T> ... contracts) {
        this.providerFactory.register(providerClass, (Class[])contracts);
        return this;
    }

    public <T> Configuration register(Class<T> providerClass, int bindingPriority, Class<? super T> ... contracts) {
        this.providerFactory.register(providerClass, bindingPriority, (Class[])contracts);
        return this;
    }

    public Configuration register(Object provider, int bindingPriority) {
        this.providerFactory.register(provider, bindingPriority);
        return this;
    }

    public <T> Configuration register(Object provider, Class<? super T> ... contracts) {
        this.providerFactory.register(provider, (Class[])contracts);
        return this;
    }

    public <T> Configuration register(Object provider, int bindingPriority, Class<? super T> ... contracts) {
        this.providerFactory.register(provider, bindingPriority, (Class[])contracts);
        return this;
    }

    public Configuration setProperties(Map<String, ? extends Object> properties) {
        this.providerFactory.setProperties(properties);
        return this;
    }

    public Configuration setProperty(String name, Object value) {
        this.providerFactory.setProperty(name, value);
        return this;
    }
}

