/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client.header;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;
import org.eclipse.microprofile.rest.client.ext.DefaultClientHeadersFactoryImpl;
import org.jboss.resteasy.microprofile.client.header.ClientHeaderProvider;
import org.jboss.resteasy.microprofile.client.header.ClientHeaderProviders;
import org.jboss.resteasy.microprofile.client.utils.ClientRequestContextUtils;
import org.jboss.resteasy.microprofile.client.utils.ListCastUtils;

@Priority(value=-2147483648)
public class ClientHeadersRequestFilter
implements ClientRequestFilter {
    private static final MultivaluedMap<String, String> EMPTY_MAP = new MultivaluedHashMap();

    public void filter(ClientRequestContext requestContext) {
        Method method = ClientRequestContextUtils.getMethod(requestContext);
        MultivaluedHashMap headers = new MultivaluedHashMap();
        Optional<ClientHeaderProvider> handler = ClientHeaderProviders.getProvider(method);
        handler.ifPresent(arg_0 -> ClientHeadersRequestFilter.lambda$0((MultivaluedMap)headers, arg_0));
        Optional<ClientHeadersFactory> factory = ClientHeaderProviders.getFactory(ClientRequestContextUtils.getDeclaringClass(requestContext));
        requestContext.getHeaders().forEach((arg_0, arg_1) -> ClientHeadersRequestFilter.lambda$1((MultivaluedMap)headers, arg_0, arg_1));
        MultivaluedMap<String, String> containerHeaders = (MultivaluedMap<String, String>)requestContext.getProperty("MP_CLIENT_CONTAINER_HEADERS");
        if (containerHeaders == null) {
            containerHeaders = EMPTY_MAP;
        }
        MultivaluedMap<String, String> incomingHeaders = containerHeaders;
        if (!factory.isPresent() || factory.get() instanceof DefaultClientHeadersFactoryImpl) {
            headers.forEach((key, values) -> {
                Object object = requestContext.getHeaders().put(key, ClientHeadersRequestFilter.castToListOfObjects(values));
            });
        }
        factory.ifPresent(arg_0 -> ClientHeadersRequestFilter.lambda$3(incomingHeaders, (MultivaluedMap)headers, requestContext, arg_0));
    }

    private static List<Object> castToListOfObjects(List<String> values) {
        return new ArrayList<Object>(values);
    }

    private static /* synthetic */ void lambda$0(MultivaluedMap multivaluedMap, ClientHeaderProvider h) {
        h.addHeaders((MultivaluedMap<String, String>)multivaluedMap);
    }

    private static /* synthetic */ void lambda$1(MultivaluedMap multivaluedMap, String key, List values) {
        Object object = multivaluedMap.put((Object)key, ListCastUtils.castToListOfStrings(values));
    }

    private static /* synthetic */ void lambda$3(MultivaluedMap multivaluedMap, MultivaluedMap multivaluedMap2, ClientRequestContext clientRequestContext, ClientHeadersFactory f) {
        f.update(multivaluedMap, multivaluedMap2).forEach((key, values) -> {
            Object object = clientRequestContext.getHeaders().put(key, ClientHeadersRequestFilter.castToListOfObjects(values));
        });
    }
}

