/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client.header;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;

public class HeaderUtils {
    private HeaderUtils() {
    }

    public static MethodHandle createMethodHandle(Method method, Object clientProxy) {
        try {
            Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
            constructor.setAccessible(true);
            MethodHandles.Lookup lookup = (MethodHandles.Lookup)constructor.newInstance(method.getDeclaringClass());
            return lookup.in(method.getDeclaringClass()).unreflectSpecial(method, method.getDeclaringClass()).bindTo(clientProxy);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RestClientDefinitionException("Failed to generate method handle for " + method, (Throwable)e);
        }
    }

    public static Method resolveMethod(String methodSpecifier, Class<?> interfaceClass, String headerName) {
        Class<?> clazz;
        String methodName;
        int lastDot = methodSpecifier.lastIndexOf(46);
        if (lastDot == methodSpecifier.length()) {
            throw new RestClientDefinitionException("Invalid string to specify method: " + methodSpecifier + " for header: '" + headerName + "' on class " + interfaceClass.getCanonicalName());
        }
        if (lastDot > -1) {
            methodName = methodSpecifier.substring(lastDot + 1);
            String className = methodSpecifier.substring(0, lastDot);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                clazz = Class.forName(className, true, loader);
            }
            catch (ClassNotFoundException e) {
                throw new RestClientDefinitionException("No class '" + className + "' found for filling header '" + headerName + " on " + interfaceClass.getCanonicalName(), (Throwable)e);
            }
        } else {
            clazz = interfaceClass;
            methodName = methodSpecifier;
        }
        Method method = null;
        boolean resolved = false;
        try {
            method = clazz.getMethod(methodName, new Class[0]);
            resolved = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (!resolved) {
            try {
                method = clazz.getMethod(methodName, String.class);
                resolved = true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (resolved) {
            return method;
        }
        throw new RestClientDefinitionException("Could not resolve method '" + methodSpecifier + "' for filling header '" + headerName + " on " + interfaceClass.getCanonicalName());
    }

    public static List<String> castListToListOfStrings(List<?> result) {
        return result.stream().map(val -> val instanceof String ? (String)val : String.valueOf(val)).collect(Collectors.toList());
    }
}

