/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client.header;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.microprofile.client.utils.ListCastUtils;
import org.jboss.resteasy.util.CookieParser;
import org.jboss.resteasy.util.DateUtil;
import org.jboss.resteasy.util.MediaTypeHelper;
import org.jboss.resteasy.util.WeightedLanguage;

public class HttpHeadersContextProvider
implements HttpHeaders {
    private final ClientRequestContext context;

    public HttpHeadersContextProvider(ClientRequestContext context) {
        this.context = context;
    }

    public MultivaluedMap<String, String> getRequestHeaders() {
        MultivaluedMap headers = this.context.getHeaders();
        MultivaluedHashMap result = new MultivaluedHashMap();
        headers.forEach((arg_0, arg_1) -> HttpHeadersContextProvider.lambda$getRequestHeaders$0((MultivaluedMap)result, arg_0, arg_1));
        return result;
    }

    public List<String> getRequestHeader(String name) {
        List vals = (List)this.getRequestHeaders().get((Object)name);
        if (vals == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(vals);
    }

    public Map<String, Cookie> getCookies() {
        HashMap<String, Cookie> cookies = new HashMap<String, Cookie>();
        List cookieHeader = (List)this.getRequestHeaders().get((Object)"Cookie");
        if (cookieHeader != null && !cookieHeader.isEmpty()) {
            for (String s : cookieHeader) {
                List list = CookieParser.parseCookies((String)s);
                for (Cookie cookie : list) {
                    cookies.put(cookie.getName(), cookie);
                }
            }
        }
        return Collections.unmodifiableMap(cookies);
    }

    public Date getDate() {
        String date = (String)this.getRequestHeaders().getFirst((Object)"Date");
        return date == null ? null : DateUtil.parseDate((String)date);
    }

    public String getHeaderString(String name) {
        List vals = (List)this.getRequestHeaders().get((Object)name);
        return vals == null ? null : String.join((CharSequence)",", vals);
    }

    public Locale getLanguage() {
        String obj = (String)this.getRequestHeaders().getFirst((Object)"Content-Language");
        return obj == null ? null : new Locale(obj);
    }

    public int getLength() {
        String obj = (String)this.getRequestHeaders().getFirst((Object)"Content-Length");
        if (obj == null) {
            return -1;
        }
        return Integer.parseInt(obj);
    }

    public MediaType getMediaType() {
        String contentType = (String)this.getRequestHeaders().getFirst((Object)"Content-Type");
        return contentType == null ? null : MediaType.valueOf((String)contentType);
    }

    public List<MediaType> getAcceptableMediaTypes() {
        String accepts = this.getHeaderString("Accept");
        if (accepts == null) {
            return Collections.singletonList(MediaType.WILDCARD_TYPE);
        }
        return this.parseToStream(accepts).map(MediaType::valueOf).sorted(MediaTypeHelper::compareWeight).collect(Collectors.toList());
    }

    public List<Locale> getAcceptableLanguages() {
        String accepts = this.getHeaderString("Accept-Language");
        if (accepts == null) {
            return Collections.singletonList(Locale.forLanguageTag("*"));
        }
        return this.parseToStream(accepts).map(WeightedLanguage::parse).sorted().map(WeightedLanguage::getLocale).collect(Collectors.toList());
    }

    private Stream<String> parseToStream(String accepts) {
        String[] splitValues = accepts.split(",");
        return Arrays.stream(splitValues).map(String::trim);
    }

    private static /* synthetic */ void lambda$getRequestHeaders$0(MultivaluedMap result, String key, List values) {
        List cfr_ignored_0 = (List)result.put((Object)key, ListCastUtils.castToListOfStrings(values));
    }
}

