/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client.async;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptor;
import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptorFactory;
import org.jboss.resteasy.spi.PriorityComparator;
import org.jboss.resteasy.spi.concurrent.ThreadContext;

public class AsyncInvocationInterceptorThreadContext
implements ThreadContext<List<AsyncInvocationInterceptor>> {
    private final List<AsyncInvocationInterceptorFactory> factories;

    public AsyncInvocationInterceptorThreadContext(Collection<AsyncInvocationInterceptorFactory> factories) {
        this.factories = new ArrayList<AsyncInvocationInterceptorFactory>(factories);
        this.factories.sort((Comparator<AsyncInvocationInterceptorFactory>)new PriorityComparator());
    }

    public List<AsyncInvocationInterceptor> capture() {
        ArrayList<AsyncInvocationInterceptor> captured = new ArrayList<AsyncInvocationInterceptor>();
        for (AsyncInvocationInterceptorFactory factory : this.factories) {
            AsyncInvocationInterceptor interceptor = factory.newInterceptor();
            interceptor.prepareContext();
            captured.add(interceptor);
        }
        return captured;
    }

    public void push(List<AsyncInvocationInterceptor> context) {
        if (context != null) {
            context.forEach(AsyncInvocationInterceptor::applyContext);
        }
    }

    public void reset(List<AsyncInvocationInterceptor> context) {
        if (context != null) {
            context.forEach(AsyncInvocationInterceptor::removeContext);
        }
    }
}

