/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.eagledns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.apache.log4j.Logger;
import org.xbill.DNS.Message;
import se.unlogic.eagledns.EagleDNS;

public class TCPConnection
implements Runnable {
    private static Logger log = Logger.getLogger(TCPConnection.class);
    private EagleDNS eagleDNS;
    private Socket socket;

    public TCPConnection(EagleDNS eagleDNS, Socket socket) {
        this.eagleDNS = eagleDNS;
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            try {
                InputStream is = this.socket.getInputStream();
                DataInputStream dataIn = new DataInputStream(is);
                int inLength = dataIn.readUnsignedShort();
                byte[] in = new byte[inLength];
                dataIn.readFully(in);
                byte[] response = null;
                try {
                    Message query = new Message(in);
                    log.debug((Object)("TCP query " + EagleDNS.toString(query.getQuestion()) + " from " + this.socket.getRemoteSocketAddress()));
                    response = this.eagleDNS.generateReply(query, in, in.length, this.socket);
                    if (response == null) {
                        return;
                    }
                }
                catch (IOException e) {
                    response = this.eagleDNS.formerrMessage(in);
                }
                DataOutputStream dataOut = new DataOutputStream(this.socket.getOutputStream());
                dataOut.writeShort(response.length);
                dataOut.write(response);
                return;
            }
            catch (IOException e2) {
                log.debug((Object)("Error sending TCP response to " + this.socket.getRemoteSocketAddress() + ":" + this.socket.getPort() + ", " + e2));
                try {
                    this.socket.close();
                    return;
                }
                catch (IOException e2) {
                    return;
                }
            }
            finally {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Throwable e) {
            log.warn((Object)("Error processing TCP connection from " + this.socket.getRemoteSocketAddress() + ":" + this.socket.getPort() + ", " + e));
        }
    }
}

