/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.string;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Set;
import se.unlogic.standardutils.string.TagSource;

public class BeanTagSource<T>
implements TagSource {
    private final T bean;
    private final Set<String> tagSet;
    private final HashMap<String, Method> tagMethodMap;
    private final HashMap<String, Field> tagFieldMap;

    public BeanTagSource(T bean, HashMap<String, Method> tagMethodMap, HashMap<String, Field> tagFieldMap, Set<String> tagSet) {
        this.bean = bean;
        this.tagMethodMap = tagMethodMap;
        this.tagFieldMap = tagFieldMap;
        this.tagSet = tagSet;
    }

    @Override
    public String getTagValue(String tag) {
        Field field = this.tagFieldMap.get(tag);
        if (field != null) {
            try {
                Object value = field.get(this.bean);
                if (value != null) {
                    return value.toString();
                }
                return null;
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        Method method = this.tagMethodMap.get(tag);
        if (method != null) {
            try {
                Object value = method.invoke(this.bean, new Object[0]);
                if (value != null) {
                    return value.toString();
                }
                return null;
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public Set<String> getTags() {
        return this.tagSet;
    }
}

