/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.exec;

import java.io.IOException;
import java.io.OutputStream;
import se.unlogic.standardutils.exec.StreamHandler;
import se.unlogic.standardutils.exec.StreamPrinter;

public class ExecUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int execAndWait(String command, Long timeout) throws IOException, InterruptedException {
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec(command);
        try {
            StreamPrinter errorOutHandler = new StreamPrinter(System.err);
            StreamPrinter stdOutHandler = new StreamPrinter();
            errorOutHandler.handleStream(proc.getErrorStream());
            stdOutHandler.handleStream(proc.getInputStream());
            int n = ExecUtils.waitForProcessAndStreams(proc, stdOutHandler, errorOutHandler, timeout);
            return n;
        }
        finally {
            if (proc != null) {
                proc.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int execAndWait(String command, StreamHandler stdOutHandler, StreamHandler errorOutHandler, Long timeout) throws IOException, InterruptedException {
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec(command);
        try {
            errorOutHandler.handleStream(proc.getErrorStream());
            stdOutHandler.handleStream(proc.getInputStream());
            int n = ExecUtils.waitForProcessAndStreams(proc, stdOutHandler, errorOutHandler, timeout);
            return n;
        }
        finally {
            if (proc != null) {
                proc.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int execAndWait(String command, OutputStream outputStream, Long timeout) throws IOException, InterruptedException {
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec(command);
        try {
            StreamPrinter errorOutHandler = new StreamPrinter(outputStream);
            StreamPrinter stdOutHandler = new StreamPrinter(outputStream);
            errorOutHandler.handleStream(proc.getErrorStream());
            stdOutHandler.handleStream(proc.getInputStream());
            int n = ExecUtils.waitForProcessAndStreams(proc, stdOutHandler, errorOutHandler, timeout);
            return n;
        }
        finally {
            if (proc != null) {
                proc.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int execAndWait(ProcessBuilder builder, OutputStream outputStream, Long timeout) throws IOException, InterruptedException {
        Process proc = builder.start();
        try {
            StreamPrinter errorOutHandler = new StreamPrinter(outputStream);
            StreamPrinter stdOutHandler = new StreamPrinter(outputStream);
            errorOutHandler.handleStream(proc.getErrorStream());
            stdOutHandler.handleStream(proc.getInputStream());
            int n = ExecUtils.waitForProcessAndStreams(proc, stdOutHandler, errorOutHandler, timeout);
            return n;
        }
        finally {
            if (proc != null) {
                proc.destroy();
            }
        }
    }

    public static int waitForProcessAndStreams(Process proc, StreamHandler stdOutHandler, StreamHandler errorOutHandler, Long timeout) throws InterruptedException {
        int exitVal;
        if (timeout != null) {
            long elapsedTimeout = 0L;
            while (true) {
                if (elapsedTimeout > timeout) {
                    proc.destroy();
                }
                Thread.sleep(100L);
                try {
                    exitVal = proc.exitValue();
                }
                catch (IllegalThreadStateException e) {
                    elapsedTimeout += 100L;
                    continue;
                }
                break;
            }
            exitVal = proc.exitValue();
            stdOutHandler.terminate();
            errorOutHandler.terminate();
        } else {
            exitVal = proc.waitFor();
        }
        if (!stdOutHandler.isFinished()) {
            stdOutHandler.awaitFinish();
        }
        if (errorOutHandler != null && !errorOutHandler.isFinished()) {
            errorOutHandler.awaitFinish();
        }
        return exitVal;
    }
}

