/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.dao.querys;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import se.unlogic.standardutils.dao.BeanResultSetPopulator;
import se.unlogic.standardutils.dao.querys.PopulatedQuery;
import se.unlogic.standardutils.db.DBUtils;

public class HashMapQuery<KeyType, ValueType>
extends PopulatedQuery<Map.Entry<KeyType, ValueType>> {
    public HashMapQuery(Connection connection, boolean closeConnectionOnExit, String query, BeanResultSetPopulator<? extends Map.Entry<KeyType, ValueType>> bp) throws SQLException {
        super(connection, closeConnectionOnExit, query, bp);
    }

    public HashMapQuery(DataSource dataSource, boolean closeConnectionOnExit, String query, BeanResultSetPopulator<? extends Map.Entry<KeyType, ValueType>> bp) throws SQLException {
        super(dataSource, closeConnectionOnExit, query, bp);
    }

    public HashMap<KeyType, ValueType> executeQuery() throws SQLException {
        ResultSet rs = null;
        HashMap returnTypeMap = null;
        try {
            Object entry;
            rs = this.pstmt.executeQuery();
            if (rs.next()) {
                returnTypeMap = new HashMap();
                rs.beforeFirst();
                while (rs.next()) {
                    entry = (Map.Entry)this.beanPopulator.populate(rs);
                    returnTypeMap.put(entry.getKey(), entry.getValue());
                }
            }
            entry = returnTypeMap;
            return entry;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            DBUtils.closeResultSet(rs);
            DBUtils.closePreparedStatement(this.pstmt);
            if (this.closeConnectionOnExit) {
                DBUtils.closeConnection(this.connection);
            }
            this.closed = true;
        }
    }
}

