/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.xsl;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import se.unlogic.standardutils.settings.XMLSettingNode;

public class XSLUtils {
    private static Pattern XSL_VARIABLE_PATTERN = Pattern.compile("(?<=\\$)[\\w\\.]*(?=($|[\\W]))");

    public static Set<String> getVariableReferenses(File file) throws SAXException, IOException, ParserConfigurationException {
        XMLSettingNode settingNode = new XMLSettingNode(file);
        List<String> tags = settingNode.getStrings("//@*[contains(.,'$')]");
        if (tags == null) {
            return null;
        }
        LinkedHashSet<String> stringSet = new LinkedHashSet<String>();
        for (String tag : tags) {
            Matcher matcher = XSL_VARIABLE_PATTERN.matcher(tag);
            while (matcher.find()) {
                stringSet.add(matcher.group());
            }
        }
        return stringSet;
    }

    public static List<String> getDeclaredVariables(File file) throws SAXException, IOException, ParserConfigurationException {
        XMLSettingNode settingNode = new XMLSettingNode(file);
        return settingNode.getStrings("//variable/@name");
    }
}

