/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.dao;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RelationQuery {
    private List<Field> relations;
    private List<Field> excludedRelations;
    private boolean disableAutoRelations;

    public RelationQuery() {
    }

    public RelationQuery(List<Field> relations) {
        this.relations = relations;
    }

    public RelationQuery(Field ... relations) {
        this.addRelations(relations);
    }

    public RelationQuery(RelationQuery relationQuery) {
        this.addRelations(relationQuery);
    }

    public List<Field> getRelations() {
        return this.relations;
    }

    public void setRelations(List<Field> relations) {
        this.relations = relations;
    }

    public void addRelation(Field relation) {
        if (this.relations == null) {
            this.relations = new ArrayList<Field>();
        }
        this.relations.add(relation);
    }

    public void addRelations(Field ... relations) {
        if (this.relations == null) {
            this.relations = new ArrayList<Field>();
        }
        this.relations.addAll(Arrays.asList(relations));
    }

    public static boolean hasRelations(RelationQuery query) {
        return query != null && query.getRelations() != null && !query.getRelations().isEmpty();
    }

    public boolean hasRelations() {
        return RelationQuery.hasRelations(this);
    }

    public void addRelations(RelationQuery relationQuery) {
        if (RelationQuery.hasRelations(relationQuery)) {
            this.addRelations(relationQuery.getRelations());
        }
    }

    public void addRelations(List<Field> relations) {
        if (this.relations == null) {
            this.relations = relations;
        } else {
            this.relations.addAll(relations);
        }
    }

    public List<Field> getExcludedRelations() {
        return this.excludedRelations;
    }

    public void setExcludedRelations(List<Field> excludedRelations) {
        this.excludedRelations = excludedRelations;
    }

    public void addExcludedRelation(Field relation) {
        if (this.excludedRelations == null) {
            this.excludedRelations = new ArrayList<Field>();
        }
        this.excludedRelations.add(relation);
    }

    public void addExcludedRelations(Field ... excludedRelations) {
        if (this.excludedRelations == null) {
            this.excludedRelations = new ArrayList<Field>();
        }
        this.excludedRelations.addAll(Arrays.asList(excludedRelations));
    }

    public static boolean hasExcludedRelations(RelationQuery query) {
        return query != null && query.getExcludedRelations() != null && !query.getExcludedRelations().isEmpty();
    }

    public boolean hasExcludedRelations() {
        return RelationQuery.hasExcludedRelations(this);
    }

    public void addExcludedRelations(RelationQuery relationQuery) {
        if (RelationQuery.hasExcludedRelations(relationQuery)) {
            this.addExcludedRelations(relationQuery.getExcludedRelations());
        }
    }

    public void addExcludedRelations(List<Field> excludedRelations) {
        if (this.excludedRelations == null) {
            this.excludedRelations = excludedRelations;
        } else {
            this.excludedRelations.addAll(excludedRelations);
        }
    }

    public boolean containsRelation(Field field) {
        if (this.relations != null) {
            return this.relations.contains(field);
        }
        return false;
    }

    public boolean containsExcludedRelation(Field field) {
        if (this.excludedRelations != null) {
            return this.excludedRelations.contains(field);
        }
        return false;
    }

    public boolean isDisableAutoRelations() {
        return this.disableAutoRelations;
    }

    public void disableAutoRelations(boolean disableAutoRelations) {
        this.disableAutoRelations = disableAutoRelations;
    }
}

