/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.json;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.unlogic.standardutils.json.JsonLeaf;
import se.unlogic.standardutils.json.JsonNode;

public class JsonArray
implements JsonNode {
    private static final long serialVersionUID = 1497880281195635145L;
    private final List<JsonNode> nodes = new ArrayList<JsonNode>();

    @Override
    public String toJson() {
        return this.toJson(new StringBuilder());
    }

    @Override
    public String toJson(StringBuilder stringBuilder) {
        stringBuilder.append("[");
        Iterator<JsonNode> iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            JsonNode node = iterator.next();
            node.toJson(stringBuilder);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public void addNode(JsonNode node) {
        this.nodes.add(node);
    }

    public void addNode(String value) {
        this.nodes.add(new JsonLeaf(value));
    }

    public void removeNode(JsonNode node) {
        this.nodes.remove(node);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodes == null ? 0 : ((Object)this.nodes).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonArray other = (JsonArray)obj;
        return !(this.nodes == null ? other.nodes != null : !((Object)this.nodes).equals(other.nodes));
    }
}

