/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remotingjmx.protocol.v2;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;
import javax.management.RuntimeMBeanException;
import org.jboss.logging.Logger;
import org.jboss.marshalling.Marshaller;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remotingjmx.ServerMessageEventHandler;
import org.jboss.remotingjmx.protocol.v2.Common;
import org.xnio.IoUtils;

public abstract class ServerCommon
extends Common {
    private static final Logger log = Logger.getLogger(ServerCommon.class);
    private final Executor executor;
    private final ServerMessageEventHandler serverMessageEventHandler;

    ServerCommon(Channel channel, Executor executor, ServerMessageEventHandler serverMessageEventHandler) {
        super(channel);
        this.executor = executor;
        this.serverMessageEventHandler = serverMessageEventHandler;
    }

    protected void sendWelcomeMessage() throws IOException {
        this.write(new Common.MessageWriter(){

            @Override
            public void write(DataOutput output) throws IOException {
                output.writeBytes("JMX");
            }
        });
        log.tracef("Written welcome message", new Object[0]);
    }

    protected void writeResponse(final Exception e, final byte inResponseTo, final int correlationId) throws IOException {
        this.write(new Common.MessageWriter(){

            @Override
            public void write(DataOutput output) throws IOException {
                output.writeByte(inResponseTo ^ 0xFFFFFF80);
                output.writeInt(correlationId);
                output.writeByte(1);
                output.writeByte(3);
                Marshaller marshaller = ServerCommon.this.prepareForMarshalling(output);
                marshaller.writeObject((Object)e);
                marshaller.finish();
            }
        });
    }

    protected void writeResponse(final byte inResponseTo, final int correlationId) throws IOException {
        this.write(new Common.MessageWriter(){

            @Override
            public void write(DataOutput output) throws IOException {
                output.writeByte(inResponseTo ^ 0xFFFFFF80);
                output.writeInt(correlationId);
                output.writeByte(0);
            }
        });
    }

    protected void writeResponse(final String response, final byte inResponseTo, final int correlationId) throws IOException {
        this.write(new Common.MessageWriter(){

            @Override
            public void write(DataOutput output) throws IOException {
                output.writeByte(inResponseTo ^ 0xFFFFFF80);
                output.writeInt(correlationId);
                output.writeByte(0);
                output.writeByte(8);
                output.writeUTF(response);
            }
        });
    }

    abstract void end();

    protected class MessageReciever
    implements Channel.Receiver {
        protected MessageReciever() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Channel channel, MessageInputStream message) {
            block8: {
                final DataInputStream dis = new DataInputStream((InputStream)message);
                boolean endReceiveLoop = false;
                try {
                    final byte messageId = dis.readByte();
                    final int correlationId = dis.readInt();
                    log.tracef("Message Received id(%h), correlationId(%d)", (Object)messageId, (Object)correlationId);
                    final Common.MessageHandler mh = ServerCommon.this.getHandlerRegistry().get(messageId);
                    if (mh instanceof MessageHandler) {
                        endReceiveLoop = ((MessageHandler)mh).endReceiveLoop();
                    }
                    if (mh != null) {
                        ServerCommon.this.executor.execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Throwable thrown = null;
                                try {
                                    if (ServerCommon.this.serverMessageEventHandler != null) {
                                        ServerCommon.this.serverMessageEventHandler.beforeEvent();
                                    }
                                    mh.handle(dis, correlationId);
                                }
                                catch (Throwable t) {
                                    thrown = t;
                                    if (correlationId != 0) {
                                        Exception response;
                                        if (t instanceof IOException) {
                                            response = (Exception)t;
                                        } else if (t instanceof RuntimeMBeanException) {
                                            response = (Exception)t;
                                        } else {
                                            response = new IOException("Internal server error.");
                                            log.warn((Object)"Unexpected internal error", t);
                                        }
                                        this.sendIOException(response);
                                    } else {
                                        log.error((Object)"null correlationId so error not sent to client", t);
                                    }
                                }
                                finally {
                                    if (ServerCommon.this.serverMessageEventHandler != null) {
                                        ServerCommon.this.serverMessageEventHandler.afterEvent(thrown);
                                    }
                                    IoUtils.safeClose((Closeable)dis);
                                }
                            }

                            private void sendIOException(Exception e) {
                                try {
                                    ServerCommon.this.writeResponse(e, messageId, correlationId);
                                    log.tracef("[%d] %h - Success Response Sent", (Object)correlationId, (Object)messageId);
                                }
                                catch (IOException ioe) {
                                    log.error((Object)ioe);
                                }
                            }
                        });
                        break block8;
                    }
                    throw new IOException("Unrecognised Message ID");
                }
                catch (IOException e) {
                    log.error((Object)e);
                    IoUtils.safeClose((Closeable)dis);
                }
                finally {
                    if (!endReceiveLoop) {
                        channel.receiveMessage((Channel.Receiver)this);
                    }
                }
            }
        }

        public void handleError(Channel channel, IOException error) {
            log.warn((Object)"Channel closing due to error", (Throwable)error);
            ServerCommon.this.end();
        }

        public void handleEnd(Channel channel) {
            ServerCommon.this.end();
        }
    }

    abstract class MessageHandler
    implements Common.MessageHandler {
        MessageHandler() {
        }

        boolean endReceiveLoop() {
            return false;
        }
    }
}

