/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.util.Collections;
import javax.xml.stream.XMLStreamReader;
import org.jboss.remoting3.ConnectionProviderFactoryBuilder;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.EndpointBuilder;
import org.wildfly.client.config.ClientConfiguration;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.client.config.ConfigurationXMLStreamReader;
import org.xnio.XnioWorker;

final class RemotingXmlParser {
    private static final String NS_REMOTING_5_0 = "urn:jboss-remoting:5.0";

    RemotingXmlParser() {
    }

    static Endpoint parseEndpoint() throws ConfigXMLParseException, IOException {
        ClientConfiguration clientConfiguration = ClientConfiguration.getInstance();
        EndpointBuilder builder = new EndpointBuilder();
        builder.setXnioWorker((XnioWorker)XnioWorker.getContextManager().get());
        if (clientConfiguration != null) {
            try (ConfigurationXMLStreamReader streamReader = clientConfiguration.readConfiguration(Collections.singleton(NS_REMOTING_5_0));){
                RemotingXmlParser.parseDocument(streamReader, builder);
                Endpoint endpoint = builder.build();
                return endpoint;
            }
        }
        return null;
    }

    private static void parseDocument(ConfigurationXMLStreamReader reader, EndpointBuilder builder) throws ConfigXMLParseException {
        if (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 1: {
                    switch (reader.getNamespaceURI()) {
                        case "urn:jboss-remoting:5.0": {
                            break;
                        }
                        default: {
                            throw reader.unexpectedElement();
                        }
                    }
                    switch (reader.getLocalName()) {
                        case "endpoint": {
                            RemotingXmlParser.parseEndpointElement(reader, builder);
                            break block0;
                        }
                    }
                    throw reader.unexpectedElement();
                }
                default: {
                    throw reader.unexpectedContent();
                }
            }
        }
    }

    private static void parseEndpointElement(ConfigurationXMLStreamReader reader, EndpointBuilder builder) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        block22: for (int i = 0; i < attributeCount; ++i) {
            switch (reader.getAttributeLocalName(i)) {
                case "name": {
                    builder.setEndpointName(reader.getAttributeValue(i));
                    continue block22;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        while (reader.hasNext()) {
            block6 : switch (reader.nextTag()) {
                case 1: {
                    switch (reader.getNamespaceURI()) {
                        case "urn:jboss-remoting:5.0": {
                            break;
                        }
                        default: {
                            throw reader.unexpectedElement();
                        }
                    }
                    switch (reader.getLocalName()) {
                        case "providers": {
                            RemotingXmlParser.parseProvidersElement(reader, builder);
                            break block6;
                        }
                    }
                    throw reader.unexpectedElement();
                }
                case 2: {
                    return;
                }
            }
        }
    }

    private static void parseProvidersElement(ConfigurationXMLStreamReader reader, EndpointBuilder builder) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        if (attributeCount > 0) {
            throw reader.unexpectedAttribute(0);
        }
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 1: {
                    switch (reader.getNamespaceURI()) {
                        case "urn:jboss-remoting:5.0": {
                            break;
                        }
                        default: {
                            throw reader.unexpectedElement();
                        }
                    }
                    switch (reader.getLocalName()) {
                        case "provider": {
                            RemotingXmlParser.parseProviderElement(reader, builder);
                            break;
                        }
                        default: {
                            throw reader.unexpectedElement();
                        }
                    }
                }
                case 2: {
                    return;
                }
            }
        }
    }

    private static void parseProviderElement(ConfigurationXMLStreamReader reader, EndpointBuilder builder) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String scheme = null;
        String[] aliases = null;
        String module = null;
        String clazz = null;
        block15: for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                throw reader.unexpectedAttribute(i);
            }
            switch (reader.getAttributeLocalName(i)) {
                case "scheme": {
                    scheme = reader.getAttributeValue(i);
                    continue block15;
                }
                case "aliases": {
                    aliases = reader.getListAttributeValueAsArray(i);
                    continue block15;
                }
                case "module": {
                    module = reader.getAttributeValue(i);
                    continue block15;
                }
                case "class": {
                    clazz = reader.getAttributeValue(i);
                    continue block15;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        ConnectionProviderFactoryBuilder providerBuilder = builder.addProvider(scheme);
        if (aliases != null) {
            for (void var11_13 : aliases) {
                providerBuilder.addAlias((String)var11_13);
            }
        }
        if (module == null && clazz == null) {
            throw new ConfigXMLParseException("At least one of the 'module' or 'class' attributes must be given", (XMLStreamReader)reader);
        }
        if (module != null) {
            providerBuilder.setModuleName(module);
        }
        if (clazz != null) {
            providerBuilder.setClassName(clazz);
        }
        switch (reader.nextTag()) {
            case 2: {
                return;
            }
        }
        throw reader.unexpectedElement();
    }
}

