/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.http;

import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.samples.http.WebInvocationHandler;
import org.jboss.remoting.transport.Connector;

public class SimpleServer {
    private static String transport = "http";
    private static String host = "localhost";
    private static int port = 5400;

    public void setupServer(String locatorURI) throws Exception {
        InvokerLocator locator = new InvokerLocator(locatorURI);
        System.out.println("Starting remoting server with locator uri of: " + locatorURI);
        Connector connector = new Connector(locator);
        connector.create();
        WebInvocationHandler invocationHandler = new WebInvocationHandler();
        connector.addInvocationHandler("sample", invocationHandler);
        connector.start();
    }

    public static void main(String[] args) {
        if (args != null && args.length == 3) {
            transport = args[0];
            host = args[1];
            port = Integer.parseInt(args[2]);
        }
        String locatorURI = transport + "://" + host + ":" + port;
        SimpleServer server = new SimpleServer();
        try {
            server.setupServer(locatorURI);
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

