/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.marshal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.loading.ClassBytes;
import org.jboss.remoting.loading.ClassUtil;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.MarshallerLoaderConstants;
import org.jboss.remoting.marshal.UnMarshaller;

public class MarshallerLoaderHandler
implements ServerInvocationHandler,
MarshallerLoaderConstants {
    private ServerInvoker invoker = null;
    private MBeanServer server = null;
    private List classLoaders;
    protected static final Logger log = Logger.getLogger((Class)MarshallerLoaderHandler.class);

    public MarshallerLoaderHandler(List classLoaders) {
        this.classLoaders = classLoaders;
    }

    public void setMBeanServer(MBeanServer server) {
        this.server = server;
    }

    public void setInvoker(ServerInvoker invoker) {
        this.invoker = invoker;
    }

    public Object invoke(InvocationRequest invocation) throws Throwable {
        Object ret = null;
        Object param = invocation.getParameter();
        Map metadMap = invocation.getRequestPayload();
        if (metadMap == null) {
            throw new RuntimeException("Can not load class as invocation request metadat map is null.");
        }
        String dataType = (String)metadMap.get("datatype");
        log.debug((Object)("MarshallerLoaderHandler received invocation with param of " + param + " and data type of " + dataType));
        if ("get_marshaller".equals(param)) {
            ret = MarshalFactory.getMarshaller(dataType, this.invoker.getSerializationType());
        } else if ("get_unmarshaller".equals(param)) {
            ret = MarshalFactory.getUnMarshaller(dataType, this.invoker.getSerializationType());
        } else if ("load_class".equals(param)) {
            String className = (String)metadMap.get("classname");
            log.debug((Object)("MarshallerLoaderHandler: loading class: " + className));
            if (className != null) {
                ret = this.loadClassBytes(className, this.invoker.getClassLoader());
                log.debug((Object)("MarshallerLoaderHandler: returning class: " + className + ": " + ret));
            } else {
                log.error((Object)("Received invocation " + param + " to load class, but metadata map key " + "classname" + " contains a null value for the class name to load."));
            }
        } else if ("load_marshaller".equals(param)) {
            Marshaller marshaller = MarshalFactory.getMarshaller(dataType, this.invoker.getSerializationType());
            if (marshaller != null) {
                String className = marshaller.getClass().getName();
                ret = this.loadClassBytes(className, this.invoker.getClassLoader());
            } else {
                log.warn((Object)("Could not find registered marshaller for data type: " + dataType));
            }
        } else if ("load_unmarshaller".equals(param)) {
            UnMarshaller unmarshaller = MarshalFactory.getUnMarshaller(dataType, this.invoker.getSerializationType());
            if (unmarshaller != null) {
                String className = unmarshaller.getClass().getName();
                ret = this.loadClassBytes(className, this.invoker.getClassLoader());
            } else {
                log.warn((Object)("Could not find registered unmarshaller for data type: " + dataType));
            }
        } else {
            log.warn((Object)("Received invocation with unknown parameter request: " + param));
        }
        return ret;
    }

    private Object loadClassBytes(String className, ClassLoader classLoader) {
        ClassBytes classBytes = null;
        if (className != null) {
            byte[] classDefinition = ClassUtil.getClassBytes(className, classLoader);
            if (classDefinition == null && this.classLoaders != null) {
                Iterator it = this.classLoaders.iterator();
                while (it.hasNext()) {
                    ClassLoader cl = (ClassLoader)it.next();
                    log.debug((Object)("trying classLoader " + cl));
                    classDefinition = ClassUtil.getClassBytes(className, cl);
                    if (classDefinition == null) continue;
                    break;
                }
            }
            if (classDefinition == null) {
                log.debug((Object)("unable to load class " + className));
            }
            classBytes = new ClassBytes(className, classDefinition);
        }
        return classBytes;
    }

    public void addListener(InvokerCallbackHandler callbackHandler) {
    }

    public void removeListener(InvokerCallbackHandler callbackHandler) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] loadByteCode(ClassLoader cl, String classname) throws ClassNotFoundException, IOException {
        byte[] bytecode = null;
        URL classURL = this.getClassURL(cl, classname);
        InputStream is = null;
        try {
            is = classURL.openStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] tmp = new byte[1024];
            int read = 0;
            while ((read = is.read(tmp)) > 0) {
                baos.write(tmp, 0, read);
            }
            bytecode = baos.toByteArray();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return bytecode;
    }

    private URL getClassURL(ClassLoader cl, String classname) throws ClassNotFoundException {
        String classRsrcName = classname.replace('.', '/') + ".class";
        URL classURL = cl.getResource(classRsrcName);
        if (classURL == null) {
            String msg = "Failed to find: " + classname + " as resource: " + classRsrcName;
            throw new ClassNotFoundException(msg);
        }
        return classURL;
    }
}

