/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.callback;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.HandleCallbackException;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.transport.ClientInvoker;

public class CallbackPoller
extends TimerTask
implements Runnable {
    public static final long DEFAULT_POLL_PERIOD = 5000L;
    public static final int DEFAULT_BLOCKING_TIMEOUT = 5000;
    public static final int DEFAULT_MAX_ERROR_COUNT = 5;
    public static final String SYNCHRONIZED_SHUTDOWN = "doSynchronizedShutdown";
    public static final String CALLBACK_POLL_PERIOD = "callbackPollPeriod";
    public static final String SCHEDULE_FIXED_RATE = "scheduleFixedRate";
    public static final String SCHEDULE_FIXED_DELAY = "scheduleFixedDelay";
    public static final String MAX_ERROR_COUNT = "maxErrorCount";
    public static final String REPORT_STATISTICS = "reportStatistics";
    private Client client = null;
    private InvokerCallbackHandler callbackHandler = null;
    private Map metadata = null;
    private Object callbackHandlerObject = null;
    private boolean blocking = false;
    private boolean synchronizedShutdown = false;
    private long pollPeriod = 5000L;
    private Timer timer;
    private String scheduleMode = "scheduleFixedRate";
    private boolean reportStatistics;
    private boolean running;
    private int maxErrorCount = -1;
    private int errorCount;
    private boolean useAllParams;
    private ArrayList toHandleList = new ArrayList();
    private ArrayList toAcknowledgeList = new ArrayList();
    private HandleThread handleThread;
    private AcknowledgeThread acknowledgeThread;
    private BlockingPollerThread blockingPollerThread;
    private static final Logger log = Logger.getLogger((Class)CallbackPoller.class);
    public static final String CALLBACK_SCHEDULE_MODE = "scheduleMode";

    public CallbackPoller(Client client, InvokerCallbackHandler callbackhandler, Map metadata, Object callbackHandlerObject) {
        this.client = client;
        this.callbackHandler = callbackhandler;
        this.metadata = new HashMap(metadata);
        this.callbackHandlerObject = callbackHandlerObject;
    }

    public void start() throws Exception {
        if (this.callbackHandler == null) {
            throw new NullPointerException("Can not poll for callbacks when InvokerCallbackHandler is null.");
        }
        if (this.client == null) {
            throw new NullPointerException("Can not poll for callbacks when Client is null.");
        }
        this.client.connect();
        this.configureParameters();
        this.handleThread = new HandleThread("HandleThread");
        this.handleThread.start();
        if (log.isTraceEnabled()) {
            log.trace((Object)("blocking: " + this.blocking));
        }
        if (this.blocking) {
            if (this.maxErrorCount == -1) {
                this.maxErrorCount = 5;
            }
            this.running = true;
            this.metadata.put("throwCallbackException", "true");
            this.blockingPollerThread = new BlockingPollerThread();
            this.blockingPollerThread.start();
        } else {
            this.timer = new Timer(true);
            if (SCHEDULE_FIXED_DELAY.equals(this.scheduleMode)) {
                this.timer.schedule((TimerTask)this, this.pollPeriod, this.pollPeriod);
            } else {
                this.timer.scheduleAtFixedRate((TimerTask)this, this.pollPeriod, this.pollPeriod);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        block14: {
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)(this + " getting callbacks for " + this.callbackHandler));
                }
                List callbacks = this.client.getCallbacks(this.callbackHandler, this.metadata);
                if (log.isTraceEnabled()) {
                    log.trace((Object)(this + " callback count: " + (callbacks == null ? 0 : callbacks.size())));
                }
                if (callbacks != null && callbacks.size() > 0) {
                    ArrayList arrayList = this.toHandleList;
                    synchronized (arrayList) {
                        this.toHandleList.addAll(callbacks);
                        if (this.toHandleList.size() == callbacks.size()) {
                            this.toHandleList.notify();
                        }
                    }
                }
                if (this.reportStatistics) {
                    this.reportStatistics(callbacks);
                }
            }
            catch (Throwable throwable) {
                if (!this.running) {
                    this.stop();
                    return;
                }
                log.error((Object)(this + " Error getting callbacks from server."), throwable);
                String errorMessage = throwable.getMessage();
                if (errorMessage != null) {
                    if (errorMessage.startsWith("Could not find listener id")) {
                        log.error((Object)("Client no longer has InvokerCallbackHandler (" + this.callbackHandler + ") registered.  Shutting down callback polling"));
                        this.stop();
                        return;
                    }
                    if (errorMessage.startsWith("Can not make remoting client invocation due to not being connected to server.")) {
                        log.error((Object)"Client no longer connected.  Shutting down callback polling");
                        this.stop();
                        return;
                    }
                }
                if (this.maxErrorCount < 0 || ++this.errorCount <= this.maxErrorCount) break block14;
                log.error((Object)("Error limit of " + this.maxErrorCount + " exceeded.  Shutting down callback polling"));
                this.stop();
                return;
            }
        }
    }

    public void stop() {
        this.stop(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(int timeout) {
        log.debug((Object)(this + " is shutting down"));
        this.running = false;
        if (!this.blocking) {
            this.cancel();
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
        if (timeout == 0) {
            return;
        }
        if (this.synchronizedShutdown) {
            CallbackPoller callbackPoller = this;
            synchronized (callbackPoller) {
                this.shutdown();
            }
        } else {
            this.shutdown();
        }
        log.debug((Object)(this + " has shut down"));
    }

    private void shutdown() {
        if (this.handleThread != null) {
            this.handleThread.shutdown();
            this.handleThread = null;
        }
        if (this.acknowledgeThread != null) {
            this.acknowledgeThread.shutdown();
            this.acknowledgeThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForAcknowledgeRequest(Callback callback) {
        Object o;
        Object callbackId;
        Map returnPayload = callback.getReturnPayload();
        if (returnPayload != null && (callbackId = returnPayload.get("callbackId")) != null && ((o = returnPayload.get("remotingAcknowledgesPushCallbacks")) instanceof String && Boolean.valueOf((String)o).booleanValue() || o instanceof Boolean && ((Boolean)o).booleanValue())) {
            ArrayList arrayList = this.toAcknowledgeList;
            synchronized (arrayList) {
                this.toAcknowledgeList.add(callback);
                if (this.toAcknowledgeList.size() == 1) {
                    if (this.acknowledgeThread == null) {
                        this.acknowledgeThread = new AcknowledgeThread("AcknowledgeThread");
                        this.acknowledgeThread.start();
                    } else {
                        this.toAcknowledgeList.notify();
                    }
                }
            }
        }
    }

    private void configureParameters() {
        Map config = new HashMap();
        ClientInvoker invoker = this.client.getInvoker();
        if (invoker != null) {
            config.putAll(invoker.getLocator().getParameters());
        }
        config.putAll(this.client.getConfiguration());
        config.putAll(this.metadata);
        Object val = config.get("useAllParams");
        if (val != null) {
            if (val instanceof String) {
                this.useAllParams = Boolean.valueOf((String)val);
            } else {
                log.warn((Object)("Value for useAllParams must be of type " + String.class.getName() + " and is " + val.getClass().getName()));
            }
        }
        log.debug((Object)(this + ": useAllParams: " + this.useAllParams));
        if (!this.useAllParams) {
            config = this.metadata;
        }
        if ((val = config.get("blockingMode")) != null) {
            if (val instanceof String) {
                if ("blocking".equals(val)) {
                    this.blocking = true;
                    this.synchronizedShutdown = false;
                } else if ("nonblocking".equals(val)) {
                    this.blocking = false;
                    this.synchronizedShutdown = true;
                } else {
                    log.warn((Object)("Value for blockingMode configuration is " + val + ". Must be either " + "blocking" + " or " + "nonblocking" + ". Using " + "blocking" + "."));
                }
            } else {
                log.warn((Object)("Value for blockingMode configuration must be of type " + String.class.getName() + " and is of type " + val.getClass().getName()));
            }
        }
        if (this.blocking) {
            this.metadata.put("blockingMode", "blocking");
        }
        if ((val = config.get("blockingTimeout")) != null) {
            if (val instanceof String) {
                try {
                    int blockingTimeout = Integer.parseInt((String)val);
                    this.metadata.put("timeout", Integer.toString(blockingTimeout));
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Error converting blockingTimeout to type long.  " + e.getMessage()));
                }
            } else {
                log.warn((Object)("Value for blockingTimeout configuration must be of type " + String.class.getName() + " and is " + val.getClass().getName()));
            }
        }
        if ((val = config.get(SYNCHRONIZED_SHUTDOWN)) != null) {
            if (val instanceof String) {
                this.synchronizedShutdown = Boolean.valueOf((String)val);
            } else {
                log.warn((Object)("Value for doSynchronizedShutdown must be of type " + String.class.getName() + " and is " + val.getClass().getName()));
            }
        }
        if ((val = config.get(CALLBACK_POLL_PERIOD)) != null) {
            if (val instanceof String) {
                try {
                    this.pollPeriod = Long.parseLong((String)val);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Error converting callbackPollPeriod to type long.  " + e.getMessage()));
                }
            } else {
                log.warn((Object)("Value for callbackPollPeriod configuration must be of type " + String.class.getName() + " and is " + val.getClass().getName()));
            }
        }
        if ((val = config.get(CALLBACK_SCHEDULE_MODE)) != null) {
            if (val instanceof String) {
                if (SCHEDULE_FIXED_DELAY.equals(val) || SCHEDULE_FIXED_RATE.equals(val)) {
                    this.scheduleMode = (String)val;
                } else {
                    log.warn((Object)("Unrecognized value for scheduleMode: " + val));
                    log.warn((Object)("Using " + this.scheduleMode));
                }
            } else {
                log.warn((Object)("Value for scheduleMode must be of type " + String.class.getName() + " and is " + val.getClass().getName()));
            }
        }
        if ((val = config.get(MAX_ERROR_COUNT)) != null) {
            if (val instanceof String) {
                try {
                    this.maxErrorCount = Integer.parseInt((String)val);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Error converting maxErrorCount to type int.  " + e.getMessage()));
                }
            } else {
                log.warn((Object)("Value for maxErrorCount configuration must be of type " + String.class.getName() + " and is " + val.getClass().getName()));
            }
        }
        if (config.get(REPORT_STATISTICS) != null) {
            this.reportStatistics = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportStatistics(List callbacks) {
        int toHandle;
        int toAcknowledge = 0;
        ArrayList arrayList = this.toHandleList;
        synchronized (arrayList) {
            toHandle = this.toHandleList.size() + this.handleThread.toHandleListCopy.size();
        }
        arrayList = this.toAcknowledgeList;
        synchronized (arrayList) {
            if (this.acknowledgeThread != null) {
                toAcknowledge = this.toAcknowledgeList.size() + this.acknowledgeThread.toAcknowledgeListCopy.size();
            }
        }
        StringBuffer message = new StringBuffer("\n");
        message.append("================================\n").append("  retrieved " + callbacks.size() + " callbacks\n").append("  callbacks waiting to be processed: " + toHandle + "\n").append("  callbacks waiting to be acknowledged: " + toAcknowledge + "\n").append("================================");
        log.info((Object)message);
    }

    static /* synthetic */ Object access$300(CallbackPoller x0) {
        return x0.callbackHandlerObject;
    }

    static /* synthetic */ void access$500(CallbackPoller x0, Callback x1) {
        x0.checkForAcknowledgeRequest(x1);
    }

    class AcknowledgeThread
    extends Thread {
        boolean running;
        boolean done;
        ArrayList toAcknowledgeListCopy;

        AcknowledgeThread(String name) {
            super(name);
            this.running = true;
            this.toAcknowledgeListCopy = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                ArrayList arrayList = CallbackPoller.this.toAcknowledgeList;
                synchronized (arrayList) {
                    while (CallbackPoller.this.toAcknowledgeList.isEmpty() && this.running) {
                        try {
                            CallbackPoller.this.toAcknowledgeList.wait();
                        }
                        catch (InterruptedException e) {
                            log.warn((Object)"unexpected interrupt");
                        }
                    }
                    if (CallbackPoller.this.toAcknowledgeList.isEmpty()) {
                        this.done = true;
                        CallbackPoller.this.toAcknowledgeList.notify();
                        return;
                    }
                    this.toAcknowledgeListCopy.addAll(CallbackPoller.this.toAcknowledgeList);
                    CallbackPoller.this.toAcknowledgeList.clear();
                }
                try {
                    if (log.isTraceEnabled()) {
                        Iterator it = this.toAcknowledgeListCopy.iterator();
                        while (it.hasNext()) {
                            Callback cb = (Callback)it.next();
                            Map map = cb.getReturnPayload();
                            log.trace((Object)("acknowledging: " + map.get("callbackId")));
                        }
                    }
                    CallbackPoller.this.client.acknowledgeCallbacks(CallbackPoller.this.callbackHandler, this.toAcknowledgeListCopy);
                    this.toAcknowledgeListCopy.clear();
                    continue;
                }
                catch (Throwable t) {
                    log.error((Object)("Error acknowledging callback for callback handler (" + CallbackPoller.this.callbackHandler + ")."), t);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            log.debug((Object)(this + " is shutting down"));
            ArrayList arrayList = CallbackPoller.this.toAcknowledgeList;
            synchronized (arrayList) {
                this.running = false;
                CallbackPoller.this.toAcknowledgeList.notify();
                while (!this.done) {
                    try {
                        CallbackPoller.this.toAcknowledgeList.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            log.debug((Object)(this + " has shut down"));
        }
    }

    class HandleThread
    extends Thread {
        boolean running;
        boolean done;
        ArrayList toHandleListCopy;
        Callback callback;

        HandleThread(String name) {
            super(name);
            this.running = true;
            this.toHandleListCopy = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            block7: while (true) {
                var1_1 = CallbackPoller.access$100(CallbackPoller.this);
                synchronized (var1_1) {
                    if (CallbackPoller.access$100(CallbackPoller.this).isEmpty() && this.running) {
                        try {
                            CallbackPoller.access$100(CallbackPoller.this).wait();
                        }
                        catch (InterruptedException e) {
                            CallbackPoller.access$200().warn((Object)"unexpected interrupt");
                            continue;
                        }
                    }
                    if (CallbackPoller.access$100(CallbackPoller.this).isEmpty()) {
                        this.done = true;
                        CallbackPoller.access$100(CallbackPoller.this).notify();
                        return;
                    }
                    this.toHandleListCopy.addAll(CallbackPoller.access$100(CallbackPoller.this));
                    CallbackPoller.access$100(CallbackPoller.this).clear();
                }
                while (true) {
                    if (!this.toHandleListCopy.isEmpty()) ** break;
                    continue block7;
                    try {
                        this.callback = (Callback)this.toHandleListCopy.remove(0);
                        this.callback.setCallbackHandleObject(CallbackPoller.access$300(CallbackPoller.this));
                        CallbackPoller.access$400(CallbackPoller.this).handleCallback(this.callback);
                    }
                    catch (HandleCallbackException e) {
                        CallbackPoller.access$200().error((Object)("Error delivering callback to callback handler (" + CallbackPoller.access$400(CallbackPoller.this) + ")."), (Throwable)e);
                    }
                    CallbackPoller.access$500(CallbackPoller.this, this.callback);
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void shutdown() {
            log.debug((Object)(this + " is shutting down"));
            ArrayList arrayList = CallbackPoller.this.toHandleList;
            synchronized (arrayList) {
                this.running = false;
                CallbackPoller.this.toHandleList.notify();
                while (!this.done) {
                    try {
                        CallbackPoller.this.toHandleList.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            log.debug((Object)(this + " has shut down"));
        }
    }

    class BlockingPollerThread
    extends Thread {
        public BlockingPollerThread() {
            String threadName = this.getName();
            int i = threadName.indexOf(45);
            String threadNumber = null;
            threadNumber = i >= 0 ? threadName.substring(i + 1) : Long.toString(System.currentTimeMillis());
            String pollerString = CallbackPoller.this.toString();
            String address = pollerString.substring(pollerString.indexOf(64));
            this.setName("CallbackPoller:" + threadNumber + "[" + address + "]");
            this.setDaemon(true);
        }

        public void run() {
            while (CallbackPoller.this.running) {
                CallbackPoller.this.run();
            }
        }
    }
}

