/*
* JBoss, Home of Professional Open Source
* Copyright 2009, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.profileservice.spi.repository.artifact;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;

import org.jboss.vfs.VirtualFile;

/**
 * The artifact repository.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision: 105476 $
 */
// TODO move this out of the ProfileService SPI
public interface ArtifactRepository<T extends ArtifactId> extends Identifiable<ArtifactRepositoryId>
{
   
   /**
    * Get the artifact repository location.
    * 
    * @return the repository location
    */
   URI getRepositoryURI();
   
   /**
    * Get the repository configuration.
    * 
    * @return the configuration
    */
    ArtifactRepositoryConfiguration<T> getConfiguration(); 

   /**
    * Checks whether this repository provides the specified
    * artifact.
    * 
    * @param artifact the artifact to resolve
    * @return true if the artifact exists, false otherwise
    */
   boolean containsArtifact(T artifact);
   
   /**
    * Get the artifact meta data.
    * 
    * @param artifactId the artifact id
    * @return the artifact
    */
   Artifact<T> getArtifact(T artifactId);
   
   /**
    * Get the available artifacts.
    * 
    * @return the artifacts
    */
   Collection<Artifact<T>> getArtifacts();
   
   /**
    * Get the filtered artifacts.
    * 
    * @param filter the artifact filter.
    * @return the artifacts.
    */
   Collection<Artifact<T>> getArtifacts(ArtifactFilter<T> filter);
   
   /**
    * Get the artifact file from the repository. 
    * 
    * @param artifact the artifact
    * @return the virtual file
    * @throws IOException
    */
   VirtualFile getArtifactFile(T artifact) throws IOException;
   
   /**
    * Get the original file of the artifact.
    * {@see ArtifactRepositoryConfiguration.VFSBackupPolicy}.
    * 
    * @param artifact the artifact
    * @return the original virtual file
    * @throws IOException
    */
   VirtualFile getOriginalFile(T artifact) throws IOException;

}

