/*
* JBoss, Home of Professional Open Source
* Copyright 2010, Red Hat Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.profileservice.spi.activation;

import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;

/**
 * The profile activation.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
public interface ProfileActivation
{

   /**
    * Get the profile key.
    * 
    * @return the profile key
    */
   ProfileKey getKey();
   
   /**
    * Get the profile meta data. 
    * 
    * @return the profile meta data
    */
   ProfileMetaData getProfileMetaData();
   
   /**
    * start()
    * 
    * @throws Exception for any error
    */
   void start() throws Exception;

   /**
    * isStarted()
    * 
    * @return true if started, false otherwise
    */
   boolean isStarted();
   
   /**
    * Check whether the dependencies of the
    * profile are resolved.
    * 
    * @return true if resolved, false otherwise
    */
   boolean isResolved();
   
   /**
    * Validate the current state of the 
    * underlying profile. 
    * 
    * @throws Exception
    */
   void validate() throws Exception;
   
   /**
    * stop()
    *
    */
   void stop();
   
}

