/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.profileservice.domain.threadpool;


import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.jboss.profileservice.domain.spi.DomainMetaData;
import org.jboss.xb.annotations.JBossXmlSchema;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

/**
 *
 */
@JBossXmlSchema(namespace= DomainMetaData.THREADS_NAMESPACE,
      elementFormDefault=XmlNsForm.QUALIFIED,
      normalizeSpace=true,
      replacePropertyRefs=true)
@XmlRootElement(name = "threads")
@XmlType(name = "threads", propOrder = {})
public final class ThreadsMetaData
{
   private List<ThreadMetaData> threads = new ArrayList<ThreadMetaData>();
   private List<ThreadGroupMetaData> threadGroups = new ArrayList<ThreadGroupMetaData>();
   private List<ExecutorMetaData> executors;

   private List<ThreadFactoryMetaData> threadFactories;
   // TODO: ThreadFactoryExecutorMetaData> threadFactoryExecutors = new ArrayList<ThreadFactoryExecutorMetaData>();
   /*
    private List<UnboundedQueueThreadPoolExecutorMetaData> unboundedQueueThreadPoolExecutors = new ArrayList<UnboundedQueueThreadPoolExecutorMetaData>();
    private List<BoundedQueueThreadPoolExecutorMetaData> boundedQueueThreadPoolExecutors = new ArrayList<BoundedQueueThreadPoolExecutorMetaData>();
    private List<QueuelessThreadPoolExecutorMetaData> queuelessThreadPoolExecutors = new ArrayList<QueuelessThreadPoolExecutorMetaData>();
    private List<ScheduledThreadPoolExecutorMetaData> scheduledThreadPoolExecutors = new ArrayList<ScheduledThreadPoolExecutorMetaData>();
    private List<UnboundedOrderedExecutorMetaData> unboundedOrderedExecutors = new ArrayList<UnboundedOrderedExecutorMetaData>();
    private List<BoundedOrderedExecutorMetaData> boundedOrderedExecutors = new ArrayList<BoundedOrderedExecutorMetaData>();
    private List<DirectExecutorMetaData> directExecutors = new ArrayList<DirectExecutorMetaData>();
   */

    public List<ThreadMetaData> getThreads() {
        return threads;
    }

    @XmlElement(name = "thread")
    public void setThreads(final List<ThreadMetaData> threads) {
        this.threads = threads;
    }

    public List<ThreadGroupMetaData> getThreadGroups() {
        return threadGroups;
    }

   @XmlElement(name = "executor")
   public List<ExecutorMetaData> getExecutors()
   {
      return executors;
   }
   public void setExecutors(List<ExecutorMetaData> executors)
   {
      this.executors = executors;
   }

   @XmlElement(name = "thread-group")
    public void setThreadGroups(final List<ThreadGroupMetaData> threadGroups) {
        this.threadGroups = threadGroups;
    }

    public List<ThreadFactoryMetaData> getThreadFactories() {
        return threadFactories;
    }

    @XmlElement(name = "thread-factory")
    public void setThreadFactories(final List<ThreadFactoryMetaData> threadFactories) {
        this.threadFactories = threadFactories;
    }

}

