package org.jboss.profileservice.domain.threadpool;

import java.util.Set;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import org.jboss.profileservice.domain.Property;
import org.jboss.profileservice.domain.spi.DomainMetaDataFragment;
import org.jboss.profileservice.domain.spi.DomainMetaDataFragmentVisitor;
import org.jboss.profileservice.domain.spi.DomainMetaData;
import org.jboss.xb.annotations.JBossXmlSchema;

@JBossXmlSchema(namespace=DomainMetaData.THREADS_NAMESPACE,
      elementFormDefault=XmlNsForm.QUALIFIED,
      normalizeSpace=true,
      replacePropertyRefs=true)
@XmlRootElement(name = "thread-pool")
@XmlType(name = "threadPoolType", propOrder={})
public class BasicThreadPoolMetaData
   implements DomainMetaDataFragment, IThreadPool
{
   private String name;
   private Set<Property> properties;

   @XmlAttribute(name="name")
   public void setName(String name)
   {
      this.name = name;
   }
   public String getName()
   {
      return name;
   }

   public void setProperties(Set<Property> properties)
   {
      this.properties = properties;
   }
   public Set<Property> getProperties()
   {
      return properties;
   }

   @Override
   public String getNameSpace()
   {
      // TODO Auto-generated method stub
      return null;
   }
   @Override
   public void visit(DomainMetaDataFragmentVisitor visitor)
   {
      // TODO Auto-generated method stub
      
   }
}
