/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.v2.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.osgi.resolver.v2.spi.AbstractBundleRevision;

public final class URLBasedResource
extends AbstractBundleRevision {
    private final String contentPath;
    private final URL contentURL;

    public URLBasedResource(URL baseURL, String contentPath) {
        this.contentPath = contentPath;
        try {
            String base = baseURL.toExternalForm();
            if (!base.endsWith("/") && !contentPath.startsWith("/")) {
                base = base + "/";
            }
            this.contentURL = new URL(base + contentPath);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public URL getContentURL() {
        return this.contentURL;
    }

    public String getContentPath() {
        return this.contentPath;
    }

    @Override
    public InputStream getContent() {
        try {
            if (this.contentURL.getProtocol().equals("file")) {
                return new FileInputStream(new File(this.contentURL.getPath()));
            }
            return this.contentURL.openStream();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

