/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.Resource;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.osgi.resolver.ResolverMessages;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XBundleWiring;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.spi.AbstractBundleWire;
import org.jboss.osgi.resolver.spi.AbstractHostedCapability;
import org.jboss.osgi.resolver.spi.AbstractWiring;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Wire;
import org.osgi.service.resolver.HostedCapability;

public class AbstractBundleWiring
extends AbstractWiring
implements XBundleWiring {
    public AbstractBundleWiring(XBundleRevision brev, List<Wire> required, List<Wire> provided) {
        super(brev, required, provided);
    }

    @Override
    protected HostedCapability getHostedCapability(XCapability cap) {
        return new AbstractHostedBundleCapability(this.getResource(), cap);
    }

    public boolean isCurrent() {
        XBundleRevision brev = this.getRevision();
        return brev.getWiringSupport().getWiring(true) == this;
    }

    public boolean isInUse() {
        return this.transistiveInUse(this, true, new HashSet<BundleWiring>());
    }

    public boolean isInUseForUninstall() {
        return this.transistiveInUse(this, false, new HashSet<BundleWiring>());
    }

    private boolean transistiveInUse(AbstractBundleWiring wiring, boolean checkCurrent, Set<BundleWiring> visited) {
        block5: {
            if (wiring == null || visited.contains(wiring)) break block5;
            visited.add(wiring);
            if (checkCurrent && wiring.isCurrent()) {
                return true;
            }
            XBundle bundle2 = (XBundle)wiring.getBundle();
            if (bundle2.isFragment()) {
                for (Wire wire : wiring.getRequiredResourceWires("osgi.wiring.host")) {
                    AbstractBundleWire bwire = (AbstractBundleWire)wire;
                    AbstractBundleWiring auxwiring = (AbstractBundleWiring)bwire.getProviderWiring(false);
                    if (auxwiring == null || !this.transistiveInUse(auxwiring, true, visited)) continue;
                    return true;
                }
            } else {
                for (Wire wire : wiring.getProvidedResourceWires(null)) {
                    AbstractBundleWire bwire = (AbstractBundleWire)wire;
                    AbstractBundleWiring auxwiring = (AbstractBundleWiring)bwire.getRequirerWiring(false);
                    if (auxwiring == null || !this.transistiveInUse(auxwiring, true, visited)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public List<BundleCapability> getCapabilities(String namespace) {
        if (!this.isInUse()) {
            return null;
        }
        ArrayList<BundleCapability> result = new ArrayList<BundleCapability>();
        for (Capability cap : this.getResourceCapabilities(namespace)) {
            result.add((BundleCapability)cap);
        }
        return Collections.unmodifiableList(result);
    }

    public List<BundleRequirement> getRequirements(String namespace) {
        if (!this.isInUse()) {
            return null;
        }
        ArrayList<BundleRequirement> result = new ArrayList<BundleRequirement>();
        for (Requirement req : this.getResourceRequirements(namespace)) {
            result.add((BundleRequirement)req);
        }
        return Collections.unmodifiableList(result);
    }

    public List<BundleWire> getProvidedWires(String namespace) {
        if (!this.isInUse()) {
            return null;
        }
        ArrayList<BundleWire> providedWires = new ArrayList<BundleWire>();
        for (Wire wire : super.getProvidedResourceWires(namespace)) {
            providedWires.add((BundleWire)wire);
        }
        return Collections.unmodifiableList(providedWires);
    }

    public List<BundleWire> getRequiredWires(String namespace) {
        if (!this.isInUse()) {
            return null;
        }
        ArrayList<BundleWire> requiredWires = new ArrayList<BundleWire>();
        for (Wire wire : super.getRequiredResourceWires(namespace)) {
            requiredWires.add((BundleWire)wire);
        }
        return Collections.unmodifiableList(requiredWires);
    }

    public XBundleRevision getRevision() {
        return this.getResource();
    }

    @Override
    public XBundleRevision getResource() {
        return (XBundleRevision)super.getResource();
    }

    public ClassLoader getClassLoader() {
        if (!this.isInUse()) {
            return null;
        }
        XBundleRevision brev = this.getRevision();
        return brev.getModuleClassLoader();
    }

    public List<URL> findEntries(String path, String filePattern, int options) {
        if (!this.isInUse()) {
            return null;
        }
        ArrayList<URL> result = new ArrayList<URL>();
        XBundleRevision brev = this.getRevision();
        Enumeration<URL> entries = brev.findEntries(path, filePattern, (options & 1) != 0);
        while (entries != null && entries.hasMoreElements()) {
            result.add(entries.nextElement());
        }
        return Collections.unmodifiableList(result);
    }

    public Collection<String> listResources(String startPath, String filePattern, int options) {
        if (startPath == null) {
            throw new IllegalArgumentException("Null rootPath");
        }
        if (startPath.startsWith("/")) {
            startPath = startPath.substring(1);
        }
        if (startPath.endsWith("/")) {
            startPath = startPath.substring(0, startPath.length() - 1);
        }
        if (filePattern == null) {
            filePattern = "*";
        }
        if (!this.isInUse() || this.getRevision().isFragment()) {
            return null;
        }
        boolean local = (options & 2) != 0;
        boolean recurse = (options & 1) != 0;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        ModuleClassLoader moduleClassLoader = this.getRevision().getModuleClassLoader();
        Pattern pattern = AbstractBundleWiring.convertToPattern(filePattern);
        Iterator itResources = moduleClassLoader.iterateResources(startPath, recurse);
        this.addResourceNames(itResources, pattern, result);
        if (!local) {
            try {
                PathFilter pathFilter;
                if (recurse && startPath.length() == 0) {
                    pathFilter = PathFilters.acceptAll();
                } else {
                    pathFilter = PathFilters.is((String)startPath);
                    if (recurse) {
                        pathFilter = PathFilters.any((PathFilter[])new PathFilter[]{pathFilter, PathFilters.match((String)(startPath + "/**"))});
                    }
                }
                itResources = moduleClassLoader.getModule().iterateResources(pathFilter);
            }
            catch (ModuleLoadException ex) {
                throw ResolverMessages.MESSAGES.illegalStateCannotIterateOverModuleResources(ex, this.getRevision());
            }
            this.addResourceNames(itResources, pattern, result);
        }
        return Collections.unmodifiableSet(result);
    }

    private static Pattern convertToPattern(String filePattern) {
        filePattern = filePattern.replace("*", ".*");
        return Pattern.compile("^" + filePattern + "$");
    }

    private void addResourceNames(Iterator<Resource> itResources, Pattern pattern, Set<String> result) {
        while (itResources.hasNext()) {
            int lastIndex;
            String filename;
            String resname = itResources.next().getName();
            if (resname.startsWith("/")) {
                resname = resname.substring(1);
            }
            if (!pattern.matcher(filename = (lastIndex = resname.lastIndexOf(47)) > 0 ? resname.substring(lastIndex + 1) : resname).matches()) continue;
            result.add(resname);
        }
    }

    public Bundle getBundle() {
        return this.getRevision().getBundle();
    }

    static class AbstractHostedBundleCapability
    extends AbstractHostedCapability
    implements BundleCapability {
        AbstractHostedBundleCapability(XResource resource, XCapability capability) {
            super(resource, capability);
        }

        public XBundleRevision getRevision() {
            return (XBundleRevision)super.getResource();
        }

        @Override
        public XBundleRevision getResource() {
            return (XBundleRevision)super.getResource();
        }
    }
}

