/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver;

import java.util.Map;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.osgi.resolver.MavenCoordinates;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XResourceBuilder;
import org.jboss.osgi.resolver.XResourceBuilderFactory;

public final class XRequirementBuilder {
    private final XResourceBuilder<XResource> resbuilder;
    private final XRequirement requirement;

    public static XRequirementBuilder create(ModuleIdentifier moduleId) {
        XRequirementBuilder reqbuilder = XRequirementBuilder.createInternal("module.identity", moduleId.getName());
        reqbuilder.resbuilder.addCapability("module.identity", moduleId.getName());
        String npart = "(name=" + moduleId.getName() + ")";
        String spart = "(slot=" + moduleId.getSlot() + ")";
        String filter = "(&" + npart + spart + ")";
        reqbuilder.requirement.getDirectives().put("filter", filter);
        return reqbuilder;
    }

    public static XRequirementBuilder create(MavenCoordinates mavenId) {
        XRequirementBuilder reqbuilder = XRequirementBuilder.createInternal("maven.identity", mavenId.getArtifactId());
        reqbuilder.resbuilder.addCapability("maven.identity", mavenId.getArtifactId());
        String gpart = "(groupId=" + mavenId.getGroupId() + ")";
        String apart = "(artifactId=" + mavenId.getArtifactId() + ")";
        String tpart = "(type=" + mavenId.getType() + ")";
        String vpart = "(version=" + mavenId.getVersion() + ")";
        String cpart = mavenId.getClassifier() != null ? "(classifier=" + mavenId.getClassifier() + ")" : "";
        String filter = "(&" + gpart + apart + tpart + vpart + cpart + ")";
        reqbuilder.requirement.getDirectives().put("filter", filter);
        return reqbuilder;
    }

    public static XRequirementBuilder create(String namespace) {
        XRequirementBuilder reqbuilder = XRequirementBuilder.createInternal(namespace, null);
        reqbuilder.resbuilder.addCapability("osgi.identity", "anonymous");
        return reqbuilder;
    }

    public static XRequirementBuilder create(String namespace, String nsvalue) {
        if ("module.identity".equals(namespace)) {
            return XRequirementBuilder.create(ModuleIdentifier.fromString((String)nsvalue));
        }
        if ("maven.identity".equals(namespace)) {
            return XRequirementBuilder.create(MavenCoordinates.parse(nsvalue));
        }
        XRequirementBuilder reqbuilder = XRequirementBuilder.createInternal(namespace, nsvalue);
        reqbuilder.resbuilder.addCapability("osgi.identity", "anonymous");
        return reqbuilder;
    }

    private static XRequirementBuilder createInternal(String namespace, String nsvalue) {
        XResourceBuilder<XResource> resbuilder = XResourceBuilderFactory.create();
        XRequirement req = resbuilder.addRequirement(namespace, nsvalue);
        return new XRequirementBuilder(resbuilder, req);
    }

    private XRequirementBuilder(XResourceBuilder<XResource> resbuilder, XRequirement requirement) {
        this.resbuilder = resbuilder;
        this.requirement = requirement;
    }

    public Map<String, Object> getAttributes() {
        return this.requirement.getAttributes();
    }

    public Map<String, String> getDirectives() {
        return this.requirement.getDirectives();
    }

    public XRequirement getRequirement() {
        XResource resource = this.resbuilder.getResource();
        String namespace = this.requirement.getNamespace();
        return (XRequirement)resource.getRequirements(namespace).get(0);
    }
}

